/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.configuration;

import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.compute.configuration.WasmConfigurationUtils;
import org.apache.ignite3.internal.compute.configuration.WasmModuleMaxMemory;
import org.apache.ignite3.internal.util.StringUtils;

public class WasmModuleMaxMemoryValidator
implements Validator<WasmModuleMaxMemory, String> {
    @Override
    public void validate(WasmModuleMaxMemory annotation, ValidationContext<String> ctx) {
        String newValue = ctx.getNewValue();
        if (StringUtils.nullOrBlank(newValue)) {
            return;
        }
        try {
            long maxMemBytes = WasmConfigurationUtils.parseMemorySize(newValue);
            WasmConfigurationUtils.memorySizeToPagesValidated(maxMemBytes);
        }
        catch (IllegalArgumentException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), e.getMessage()));
        }
    }
}

