/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.io.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ignite3.client.IgniteClientConfiguration;
import org.apache.ignite3.client.IgniteClientConnectionException;
import org.apache.ignite3.client.SslConfiguration;
import org.apache.ignite3.internal.client.ClientMetricSource;
import org.apache.ignite3.internal.client.io.ClientConnection;
import org.apache.ignite3.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite3.internal.client.io.ClientConnectionStateHandler;
import org.apache.ignite3.internal.client.io.ClientMessageHandler;
import org.apache.ignite3.internal.client.io.netty.DefaultExceptionHandler;
import org.apache.ignite3.internal.client.io.netty.NettyClientConnection;
import org.apache.ignite3.internal.client.io.netty.NettyClientMessageHandler;
import org.apache.ignite3.internal.client.proto.ClientMessageDecoder;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class NettyClientConnectionMultiplexer
implements ClientConnectionMultiplexer {
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Bootstrap bootstrap = new Bootstrap();
    private final ClientMetricSource metrics;

    public NettyClientConnectionMultiplexer(ClientMetricSource metrics) {
        this.metrics = metrics;
    }

    @Override
    public void start(final IgniteClientConfiguration clientCfg) {
        try {
            final SslContext sslCtx = NettyClientConnectionMultiplexer.setupSsl(clientCfg.ssl());
            this.bootstrap.group((EventLoopGroup)this.workerGroup);
            this.bootstrap.channel(NioSocketChannel.class);
            this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)clientCfg.connectTimeout()));
            this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    if (sslCtx != null) {
                        ch.pipeline().addFirst("ssl", (ChannelHandler)sslCtx.newHandler(ch.alloc()));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true), new ClientMessageDecoder(), new NettyClientMessageHandler(), new DefaultExceptionHandler(clientCfg)});
                }
            });
        }
        catch (Throwable t) {
            this.workerGroup.shutdownGracefully();
            throw t;
        }
    }

    @Nullable
    private static SslContext setupSsl(@Nullable SslConfiguration ssl) {
        if (ssl == null || !ssl.enabled()) {
            return null;
        }
        try {
            SslContextBuilder builder = SslContextBuilder.forClient().trustManager(NettyClientConnectionMultiplexer.loadTrustManagerFactory(ssl)).keyManager(NettyClientConnectionMultiplexer.loadKeyManagerFactory(ssl)).ciphers(ssl.ciphers());
            builder.endpointIdentificationAlgorithm(null);
            return builder.build();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IgniteClientConnectionException(ErrorGroups.Client.CLIENT_SSL_CONFIGURATION_ERR, "Client SSL configuration error: " + e.getMessage(), null, (Throwable)e);
        }
    }

    private static KeyManagerFactory loadKeyManagerFactory(SslConfiguration ssl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (ssl.keyStorePath() != null) {
            char[] ksPassword = ssl.keyStorePassword() == null ? null : ssl.keyStorePassword().toCharArray();
            KeyStore ks = KeyStore.getInstance(new File(ssl.keyStorePath()), ksPassword);
            keyManagerFactory.init(ks, ksPassword);
        } else {
            keyManagerFactory.init(null, null);
        }
        return keyManagerFactory;
    }

    private static TrustManagerFactory loadTrustManagerFactory(SslConfiguration ssl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (ssl.trustStorePath() != null) {
            char[] tsPassword = ssl.trustStorePassword() == null ? null : ssl.trustStorePassword().toCharArray();
            KeyStore ts = KeyStore.getInstance(new File(ssl.trustStorePath()), tsPassword);
            trustManagerFactory.init(ts);
        } else {
            trustManagerFactory.init((KeyStore)null);
        }
        return trustManagerFactory;
    }

    @Override
    public void stop() {
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public CompletableFuture<ClientConnection> openAsync(InetSocketAddress addr, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd) throws IgniteClientConnectionException {
        CompletableFuture<ClientConnection> fut = new CompletableFuture<ClientConnection>();
        ChannelFuture connectFut = this.bootstrap.connect((SocketAddress)addr);
        connectFut.addListener(f -> {
            if (f.isSuccess()) {
                this.metrics.connectionsEstablishedIncrement();
                this.metrics.connectionsActiveIncrement();
                ChannelFuture chFut = (ChannelFuture)f;
                chFut.channel().closeFuture().addListener(unused -> this.metrics.connectionsActiveDecrement());
                NettyClientConnection conn = new NettyClientConnection(addr, chFut.channel(), msgHnd, stateHnd, this.metrics);
                fut.complete(conn);
            } else {
                Throwable cause = f.cause();
                IgniteClientConnectionException err = new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Client failed to connect: " + cause.getMessage(), addr.toString(), cause);
                fut.completeExceptionally(err);
            }
        });
        return fut;
    }
}

