/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.ArrayUtils;

public class NewIndexEntry
implements UpdateEntry,
Fireable {
    private final CatalogIndexDescriptor descriptor;

    public NewIndexEntry(CatalogIndexDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogIndexDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateIndexEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.descriptor.tableId());
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        CatalogIndexDescriptor newDescriptor = this.descriptor.upgradeIfNeeded(table);
        newDescriptor.updateTimestamp(timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), ArrayUtils.concat(schema.indexes(), newDescriptor), schema.systemViews(), schema.sequences(), schema.policies(), schema.maps(), timestamp), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString(this);
    }
}

