/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.List;
import org.apache.ignite3.cache.CacheWriteMode;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class CatalogTableDescriptorSerializers {

    @CatalogSerializer(version=6, since="gridgain-9.1.11")
    static class TableDescriptorSerializerV6
    extends TableDescriptorSerializerV5 {
        TableDescriptorSerializerV6() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableDescriptor v5descriptor = super.readFrom(input);
            double staleRowsFraction = input.readDouble();
            long minStaleRowsCount = input.readVarInt();
            return v5descriptor.copyBuilder().staleRowsFraction(staleRowsFraction).minStaleRowsCount(minStaleRowsCount).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeDouble(descriptor.properties().staleRowsFraction());
            output.writeVarInt(descriptor.properties().minStaleRowsCount());
        }
    }

    @CatalogSerializer(version=5, since="gridgain-9.1.6")
    static class TableDescriptorSerializerV5
    extends TableDescriptorSerializerV4 {
        TableDescriptorSerializerV5() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableDescriptor v4descriptor = super.readFrom(input);
            boolean rlsEnabled = input.readBoolean();
            if (rlsEnabled) {
                return v4descriptor.copyBuilder().rowLevelSecurityEnabled(true).build();
            }
            return v4descriptor;
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeBoolean(descriptor.securityEnabled());
        }
    }

    @CatalogSerializer(version=4, since="gridgain-9.1.4")
    static class TableDescriptorSerializerV4
    extends TableDescriptorSerializerV3 {
        TableDescriptorSerializerV4() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableDescriptor v3descriptor = super.readFrom(input);
            CatalogSecondaryStorageState secondaryStorageState = CatalogSecondaryStorageState.fromId(input.readVarIntAsInt());
            return v3descriptor.copyBuilder().secondaryStorageState(secondaryStorageState).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeVarInt(descriptor.secondaryStorageState().id());
        }
    }

    @CatalogSerializer(version=3, since="gridgain-9.1.1")
    static class TableDescriptorSerializerV3
    extends TableDescriptorSerializerV2 {
        TableDescriptorSerializerV3() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableDescriptor v2descriptor = super.readFrom(input);
            String archiveColumnName = CatalogSerializationUtils.readNullableString(input);
            Integer archiveColumnIndexId = null;
            Integer archiveColumnId = null;
            if (archiveColumnName != null) {
                archiveColumnId = v2descriptor.column(archiveColumnName).id();
                archiveColumnIndexId = input.readVarIntAsInt();
            }
            return v2descriptor.copyBuilder().archiveColumn(archiveColumnId).archiveColumnIndexId(archiveColumnIndexId).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            String archiveColumn = descriptor.archiveColumn();
            CatalogSerializationUtils.writeNullableString(archiveColumn, output);
            if (archiveColumn != null) {
                Integer archiveColumnIndexId = descriptor.archiveColumnIndexId();
                assert (archiveColumnIndexId != null);
                output.writeVarInt(archiveColumnIndexId.intValue());
            }
        }
    }

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class TableDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogTableDescriptor> {
        TableDescriptorSerializerV2() {
        }

        @Override
        public CatalogTableDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            IntArrayList colocationColumns;
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(updateTimestampLong);
            CatalogTableSchemaVersions schemaVersions = input.readEntry(CatalogTableSchemaVersions.class);
            List<CatalogTableColumnDescriptor> columns = schemaVersions.latestVersionColumns();
            input.readEntryList(CatalogTableColumnDescriptor.class);
            String storageProfile = input.readUTF();
            String secondaryStorageProfile = CatalogSerializationUtils.readNullableString(input);
            int schemaId = input.readVarIntAsInt();
            int pkIndexId = input.readVarIntAsInt();
            int zoneId = input.readVarIntAsInt();
            Integer secondaryZoneId = CatalogSerializationUtils.readNullableInteger(input);
            int pkKeysLen = input.readVarIntAsInt();
            int[] pkColumnIndexes = input.readIntArray(pkKeysLen);
            IntArrayList primaryKeyColumns = new IntArrayList(pkColumnIndexes.length);
            for (int idx : pkColumnIndexes) {
                primaryKeyColumns.add(columns.get(idx).id());
            }
            int colocationColumnsLen = input.readVarIntAsInt();
            if (colocationColumnsLen == -1) {
                colocationColumns = primaryKeyColumns;
            } else {
                int[] colocationColumnIdxs;
                colocationColumns = new IntArrayList(colocationColumnsLen);
                for (int idx : colocationColumnIdxs = input.readIntArray(colocationColumnsLen)) {
                    colocationColumns.add(columns.get(idx).id());
                }
            }
            boolean cache = input.readBoolean();
            String expireColumnName = CatalogSerializationUtils.readNullableString(input);
            Integer expireColumnId = null;
            Integer expireColumnIndexId = null;
            if (expireColumnName != null) {
                expireColumnIndexId = input.readVarIntAsInt();
                for (CatalogTableColumnDescriptor column : schemaVersions.latestVersionColumns()) {
                    if (!expireColumnName.equals(column.name())) continue;
                    expireColumnId = column.id();
                    break;
                }
            }
            boolean isLockedForAccess = input.readBoolean();
            CacheWriteMode cacheWriteMode = CacheWriteMode.fromOrdinal(input.readVarIntAsInt());
            return CatalogTableDescriptor.builder().id(id).schemaId(schemaId).primaryKeyIndexId(pkIndexId).name(name).zoneId(zoneId).primaryKeyColumns((IntList)primaryKeyColumns).colocationColumns((IntList)colocationColumns).schemaVersions(schemaVersions).storageProfile(storageProfile).secondaryZoneId(secondaryZoneId).secondaryStorageProfile(secondaryStorageProfile).timestamp(updateTimestamp).cache(cache).expireColumn(expireColumnId).expireColumnIndexId(expireColumnIndexId).lockedForAccess(isLockedForAccess).cacheWriteMode(cacheWriteMode).build();
        }

        @Override
        public void writeTo(CatalogTableDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeEntry(descriptor.schemaVersions());
            output.writeEntryList(descriptor.columns());
            output.writeUTF(descriptor.storageProfile());
            CatalogSerializationUtils.writeNullableString(descriptor.secondaryStorageProfile(), output);
            output.writeVarInt(descriptor.schemaId());
            output.writeVarInt(descriptor.primaryKeyIndexId());
            output.writeVarInt(descriptor.zoneId());
            CatalogSerializationUtils.writeNullableInteger(descriptor.secondaryZoneId(), output);
            int[] pkIndexes = TableDescriptorSerializerV2.resolvePkColumnIndexes(descriptor);
            output.writeVarInt(pkIndexes.length);
            output.writeIntArray(pkIndexes);
            if (descriptor.colocationColumnNames() == descriptor.primaryKeyColumnNames()) {
                output.writeVarInt(-1L);
            } else {
                int[] colocationIndexes = TableDescriptorSerializerV2.resolveColocationColumnIndexes(pkIndexes, descriptor);
                output.writeVarInt(colocationIndexes.length);
                output.writeIntArray(colocationIndexes);
            }
            output.writeBoolean(descriptor.cache());
            CatalogSerializationUtils.writeNullableString(descriptor.expireColumn(), output);
            if (descriptor.expireColumnIndexId() != null) {
                output.writeVarInt(descriptor.expireColumnIndexId().intValue());
            }
            output.writeBoolean(descriptor.isLockedForAccess());
            output.writeVarInt(descriptor.writeMode().ordinal());
        }

        private static int[] resolveColocationColumnIndexes(int[] pkColumnIndexes, CatalogTableDescriptor descriptor) {
            List<String> colocationColumns = descriptor.colocationColumnNames();
            int[] colocationColumnIndexes = new int[colocationColumns.size()];
            block0: for (int idx : pkColumnIndexes) {
                String columnName = descriptor.columns().get(idx).name();
                for (int j = 0; j < colocationColumns.size(); ++j) {
                    if (!colocationColumns.get(j).equals(columnName)) continue;
                    colocationColumnIndexes[j] = idx;
                    continue block0;
                }
            }
            return colocationColumnIndexes;
        }

        private static int[] resolvePkColumnIndexes(CatalogTableDescriptor descriptor) {
            List<CatalogTableColumnDescriptor> columns = descriptor.columns();
            List<String> pkColumns = descriptor.primaryKeyColumnNames();
            assert (columns.size() >= pkColumns.size());
            int[] pkColumnIndexes = new int[pkColumns.size()];
            int foundCount = 0;
            block0: for (int i = 0; i < columns.size() && foundCount < pkColumnIndexes.length; ++i) {
                for (int j = 0; j < pkColumns.size(); ++j) {
                    String pkColumn = pkColumns.get(j);
                    if (!pkColumn.equals(columns.get(i).name())) continue;
                    pkColumnIndexes[j] = i;
                    ++foundCount;
                    continue block0;
                }
            }
            assert (foundCount == pkColumnIndexes.length);
            return pkColumnIndexes;
        }
    }
}

