/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropMapCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropMapEntry;
import org.apache.ignite3.internal.catalog.storage.DropTableEntry;
import org.apache.ignite3.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;

public class DropMapCommand
implements CatalogCommand {
    private final String schemaName;
    private final String mapName;

    public static DropMapCommandBuilder builder() {
        return new Builder();
    }

    private DropMapCommand(String schemaName, String mapName) {
        this.schemaName = schemaName;
        this.mapName = mapName;
        this.validate();
    }

    private void validate() {
        if (this.schemaName != null && CatalogUtils.isSystemSchema(this.schemaName)) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Operations with reserved schemas are not allowed, schema: {}", this.schemaName));
        }
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.mapName, "Name of the map");
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, true);
        if (schema == null) {
            return List.of();
        }
        CatalogMapDescriptor map = schema.map(this.mapName);
        if (map == null) {
            throw new CatalogValidationException("Map with name '{}.{}' not found.", schema.name(), this.mapName);
        }
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        if (systemSchema == null) {
            return List.of();
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(systemSchema.indexes()).filter(ix -> ix.tableId() == map.tableId()).forEach(ix -> updateEntries.add(new RemoveIndexEntry(ix.id())));
        updateEntries.add(new DropTableEntry(map.tableId()));
        updateEntries.add(new DropMapEntry(map.id()));
        return updateEntries;
    }

    private static class Builder
    implements DropMapCommandBuilder {
        private String schemaName;
        private String mapName;

        private Builder() {
        }

        @Override
        public DropMapCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropMapCommandBuilder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Override
        public DropMapCommand build() {
            return new DropMapCommand(this.schemaName, this.mapName);
        }
    }
}

