/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTablePolicyCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.CreateTablePolicyCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyPredicate;
import org.apache.ignite3.internal.catalog.storage.NewTablePolicyEntry;
import org.apache.ignite3.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CreateTablePolicyCommand
extends AbstractTablePolicyCommand {
    private final String tableName;
    private final Set<String> roles;
    private final CatalogTablePolicyPredicate predicate;

    public static CreateTablePolicyCommandBuilder builder() {
        return new Builder();
    }

    private CreateTablePolicyCommand(String schemaName, String policyName, String tableName, @Nullable Set<String> roles, CatalogTablePolicyPredicate predicate) throws CatalogValidationException {
        super(schemaName, policyName);
        this.tableName = tableName;
        this.roles = roles == null ? Set.of() : roles;
        this.predicate = predicate;
        CreateTablePolicyCommand.validate(tableName, this.roles, predicate);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, true);
        assert (schema != null);
        CatalogTablePolicyDescriptor policy = schema.policy(this.policyName);
        if (policy != null) {
            throw new CatalogValidationException("Policy with name '{}.{}' already exists.", schema.name(), this.policyName);
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, true);
        assert (table != null);
        assert (!table.cache());
        CreateTablePolicyCommand.validatePredicate(this.schemaName, table, this.predicate);
        CatalogTablePolicyDescriptor descriptor = new CatalogTablePolicyDescriptor(catalog.objectIdGenState(), this.policyName, CatalogManager.INITIAL_TIMESTAMP, schema.id(), table.id(), this.roles, this.predicate);
        return List.of(new NewTablePolicyEntry(descriptor), new ObjectIdGenUpdateEntry(1));
    }

    private static void validate(String tableName, Set<String> roles, CatalogTablePolicyPredicate predicate) {
        CatalogParamsValidationUtils.validateIdentifier(tableName, "Name of the table");
        for (String roleName : roles) {
            CatalogParamsValidationUtils.validateIdentifier(roleName, "Role name");
        }
        Objects.requireNonNull(predicate, "Predicate can't be null.");
    }

    private static void validatePredicate(String schemaName, CatalogTableDescriptor table, CatalogTablePolicyPredicate predicate) {
        if (predicate instanceof CatalogTablePolicyPredicate.CurrentUserPolicyPredicate) {
            String targetColumnName = ((CatalogTablePolicyPredicate.CurrentUserPolicyPredicate)predicate).columnName();
            CatalogTableColumnDescriptor column = table.column(targetColumnName);
            if (column == null) {
                throw new CatalogValidationException("The policy target column doesn't exist [schema={}, table={}, column={}].", schemaName, table.name(), targetColumnName);
            }
            if (column.type() != ColumnType.STRING) {
                throw new CatalogValidationException("The policy target column must be of the VARCHAR type [schema={}, table={}, column={}].", schemaName, table.name(), targetColumnName);
            }
        }
    }

    private static class Builder
    implements CreateTablePolicyCommandBuilder {
        private String schemaName;
        private String policyName;
        private String tableName;
        private Set<String> roles;
        private CatalogTablePolicyPredicate predicate;

        private Builder() {
        }

        @Override
        public CreateTablePolicyCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateTablePolicyCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CreateTablePolicyCommandBuilder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        @Override
        public CreateTablePolicyCommandBuilder roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        @Override
        public CreateTablePolicyCommandBuilder predicate(CatalogTablePolicyPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateTablePolicyCommand(this.schemaName, this.policyName, this.tableName, this.roles, this.predicate);
        }
    }
}

