/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.parquet.ObjectGroup;
import org.gridgain.internal.sql.copy.parquet.ParquetGroupUtils;
import org.gridgain.internal.sql.copy.parquet.RowGroupReader;
import org.jetbrains.annotations.Nullable;

class ParquetFileReader
implements Reader {
    private final MessageType schema;
    private final org.apache.parquet.hadoop.ParquetFileReader parquetFileReader;
    private final List<String> columns;
    private final long totalRecordCount;
    @Nullable
    private RowGroupReader currentRowReader;
    private int recordsRead = 0;

    ParquetFileReader(InputFile inputFile, List<String> columns) throws IOException {
        this.columns = columns.stream().map(String::toLowerCase).collect(Collectors.toList());
        try {
            this.parquetFileReader = new org.apache.parquet.hadoop.ParquetFileReader(inputFile, ParquetReadOptions.builder().build());
        }
        catch (IOException e) {
            throw new IOException("Failed to read Parquet file: " + String.valueOf(inputFile), e);
        }
        this.schema = this.parquetFileReader.getFileMetaData().getSchema();
        this.totalRecordCount = this.parquetFileReader.getRecordCount();
    }

    @Override
    public boolean hasNext() {
        return (long)this.recordsRead < this.totalRecordCount;
    }

    @Override
    public List<?> next() {
        while (this.currentRowReader == null || !this.currentRowReader.hasNext()) {
            this.currentRowReader = this.getNextRowGroup();
        }
        ObjectGroup group = this.currentRowReader.readNext();
        ++this.recordsRead;
        return this.getRowFromGroup(group);
    }

    private List<Object> getRowFromGroup(ObjectGroup group) {
        HashMap<String, Object> parquetValues = IgniteUtils.newHashMap(this.schema.getFields().size());
        for (Type field : this.schema.getFields()) {
            parquetValues.put(field.getName().toLowerCase(), ParquetGroupUtils.getValueFromGroup(field, group, this.schema.getFieldIndex(field.getName())));
        }
        ArrayList<Object> row = new ArrayList<Object>(this.columns.size());
        for (String column : this.columns) {
            row.add(parquetValues.get(column));
        }
        return row;
    }

    private RowGroupReader getNextRowGroup() {
        try {
            PageReadStore pages = this.parquetFileReader.readNextRowGroup();
            assert (pages != null);
            return new RowGroupReader(this.schema, pages);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.parquetFileReader.close();
    }

    long totalRecordCount() {
        return this.totalRecordCount;
    }

    String getFileName() {
        return this.parquetFileReader.getFile();
    }

    MessageType getSchema() {
        return this.schema;
    }
}

