/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotUtils;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.coordinator.RecoverySubscriber;
import org.gridgain.internal.snapshots.coordinator.RestoreSnapshotLocalStateWatch;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.coordinator.SnapshotRestorationProcess;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;

class RestoreSnapshotRecoveryHandler
extends RecoverySubscriber {
    private static final IgniteLogger LOG = Loggers.forClass(RestoreSnapshotRecoveryHandler.class);
    private final SnapshotCoordinatorState snapshotCoordinatorState;

    RestoreSnapshotRecoveryHandler(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState) {
        super(context);
        this.snapshotCoordinatorState = snapshotCoordinatorState;
    }

    @Override
    public void onNext(Entry entry) {
        RestoreSnapshotGlobalState globalState = RestoreSnapshotGlobalStateSerializer.deserialize(entry.value());
        if (this.snapshotCoordinatorState.hasOngoingSnapshotOperation(globalState.operationId())) {
            return;
        }
        switch (globalState.status()) {
            case COMPLETED: 
            case FAILED: {
                break;
            }
            case PREPARED: {
                this.performRecovery(globalState, localStateWatch -> {
                    SnapshotRestorationProcess snapshotRestorationProcess = new SnapshotRestorationProcess(this.context, this.snapshotCoordinatorState);
                    return snapshotRestorationProcess.startSnapshotRestoration((RestoreSnapshotLocalStateWatch)localStateWatch, globalState);
                });
                break;
            }
            case STARTED: {
                this.performRecovery(globalState, localStateWatch -> this.replayEvents(globalState, (RestoreSnapshotLocalStateWatch)localStateWatch));
                break;
            }
            default: {
                LOG.error("Unexpected Snapshot Status: {}", new Object[]{globalState.status()});
            }
        }
    }

    private void performRecovery(RestoreSnapshotGlobalState globalState, Function<RestoreSnapshotLocalStateWatch, CompletableFuture<Void>> action) {
        LOG.info("Starting Snapshot recovery for Snapshot Operation {}, current state: {}", globalState.operationId(), globalState);
        CompletableFuture<LogicalTopologySnapshot> logicalTopologyFuture = this.context.logicalTopologyService().logicalTopologyOnLeader();
        SnapshotFileSystem snapshotFileSystem = this.context.snapshotFileSystemManager().snapshotFileSystem(globalState.targetSnapshotId(), globalState.snapshotUri());
        SnapshotMeta snapshotMeta = this.context.snapshotMetaSerializer().readSnapshotMeta(snapshotFileSystem);
        RestoreSnapshotLocalStateWatch localStateWatch = new RestoreSnapshotLocalStateWatch(this.context, this.snapshotCoordinatorState, globalState, snapshotMeta);
        SnapshotUtils.filterTables(snapshotMeta, globalState.tableNames());
        ((CompletableFuture)((CompletableFuture)logicalTopologyFuture.thenComposeAsync(topology -> {
            Set topologyNodes = topology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            Set<String> snapshotNodes = globalState.nodeNames();
            Set<String> missingNodes = CollectionUtils.difference(snapshotNodes, topologyNodes);
            if (!missingNodes.isEmpty()) {
                LOG.info("Nodes {} are no longer present in the topology, cancelling Snapshot Operation {}", missingNodes, globalState.operationId());
                String errorMessage = "Some nodes are missing from the topology: " + missingNodes;
                return localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
            return (CompletionStage)action.apply(localStateWatch);
        }, (Executor)this.context.threadPool())).thenRunAsync(() -> {
            if (globalState.catalogVersion() != -1) {
                Catalog catalog = this.context.catalogManager().catalog(globalState.catalogVersion());
                List<CatalogTableDescriptor> tableDescriptors = SnapshotUtils.tempTableDescriptors(snapshotMeta, globalState.operationId(), catalog);
                this.snapshotCoordinatorState.rebalanceWatch().addOperation(globalState.operationId(), tableDescriptors);
            }
        }, this.context.threadPool())).whenComplete((v, e) -> {
            if (e == null) {
                LOG.info("Recovery complete for Snapshot Operation {}.", globalState.operationId());
            } else {
                String errorMessage = String.format("Error when performing recovery for Snapshot Operation %s: %s", globalState.operationId(), e.getMessage());
                LOG.error(errorMessage, (Throwable)e);
                localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
        });
    }

    private CompletableFuture<Void> replayEvents(RestoreSnapshotGlobalState globalState, RestoreSnapshotLocalStateWatch localStateWatch) {
        ByteArray prefix = MetaStorageKeys.restoreSnapshotLocalStatePrefix(globalState.operationId());
        this.context.metaStorageManager().registerPrefixWatch(prefix, localStateWatch);
        return this.replayEvents(localStateWatch, prefix);
    }
}

