/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;

public class GlobalSnapshotStateSerializer
extends VersionedSerializer<GlobalSnapshotState> {
    public static final GlobalSnapshotStateSerializer INSTANCE = new GlobalSnapshotStateSerializer();

    @Override
    protected void writeExternalData(GlobalSnapshotState state, IgniteDataOutput out) throws IOException {
        out.writeVarInt(state.status().code());
        GlobalSnapshotStateSerializer.writeStringSet(state.nodeNames(), out);
        out.writeLong(state.startTime().toEpochMilli());
        out.writeUTF(state.description());
        out.writeUuid(state.operationId());
        GlobalSnapshotStateSerializer.writeSnapshotUri(out, state.snapshotUri());
    }

    private static void writeSnapshotUri(IgniteDataOutput out, SnapshotUri snapshotUri) throws IOException {
        out.writeUTF(snapshotUri.uri().toString());
        out.writeUTF(snapshotUri.type().name());
    }

    @Override
    protected GlobalSnapshotState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        SnapshotStatus status = SnapshotStatus.fromCode(in.readVarIntAsInt());
        Set<String> nodeNames = GlobalSnapshotStateSerializer.readStringSet(in);
        Instant startTime = Instant.ofEpochMilli(in.readLong());
        String description = in.readUTF();
        UUID operationId = in.readUuid();
        SnapshotUri snapshotUri = GlobalSnapshotStateSerializer.readSnapshotUri(in);
        return new GlobalSnapshotState(operationId, status, nodeNames, startTime, description, snapshotUri);
    }

    private static SnapshotUri readSnapshotUri(IgniteDataInput in) throws IOException {
        URI uri = URI.create(in.readUTF());
        SnapshotUri.PathType type = SnapshotUri.PathType.valueOf(in.readUTF());
        return new SnapshotUri(uri, type);
    }
}

