/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextIsNotSetException;
import org.jetbrains.annotations.Nullable;

public class SecurityContextHolder {
    private static final ThreadLocal<SecurityContext> state = new ThreadLocal();

    public static SecurityContext getOrThrow() {
        SecurityContext securityContext = state.get();
        if (securityContext == null) {
            throw new SecurityContextIsNotSetException();
        }
        return securityContext;
    }

    @Nullable
    public static SecurityContext getOrNull() {
        return state.get();
    }

    public static void set(@Nullable SecurityContext ctx) {
        state.set(ctx);
    }

    public static void clear() {
        state.remove();
    }
}

