/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.upgrade;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.upgrade.RollingUpgradeApi;
import org.apache.ignite3.internal.rest.api.upgrade.UpgradeStateResponse;
import org.apache.ignite3.internal.util.StringUtils;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.rest.upgrade.exception.VersionIsNotDefinedException;
import org.gridgain.internal.upgrade.RollingUpgradeManager;

@Controller(value="/management/v1/upgrade")
public class RollingUpgradeController
implements RollingUpgradeApi,
ResourceHolder,
SecurityContextAware {
    private RollingUpgradeManager upgradeManager;
    private final SecurityService securityService;

    public RollingUpgradeController(RollingUpgradeManager upgradeManager, SecurityService securityService) {
        this.upgradeManager = upgradeManager;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<Boolean> startUpgrade(String version) {
        if (StringUtils.nullOrBlank(version)) {
            throw new VersionIsNotDefinedException("Version is not defined.");
        }
        return this.secured(() -> this.upgradeManager.startUpgrade(version));
    }

    @Override
    public CompletableFuture<Boolean> commitUpgrade() {
        return this.secured(() -> this.upgradeManager.commitUpgrade());
    }

    @Override
    public CompletableFuture<Boolean> cancelUpgrade() {
        return this.secured(() -> this.upgradeManager.cancelUpgrade());
    }

    @Override
    public CompletableFuture<UpgradeStateResponse> upgradeState() {
        return this.secured(() -> this.upgradeManager.upgradeState()).thenApply(state -> new UpgradeStateResponse(state.currentVersion(), state.nextVersion(), state.currentVersionNodes(), state.nextVersionNodes()));
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    @Override
    public void cleanResources() {
        this.upgradeManager = null;
    }
}

