/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.subscription.AccumulateException;
import org.apache.ignite3.internal.util.subscription.Accumulator;
import org.gridgain.internal.pitr.PitrManagerContext;
import org.gridgain.internal.pitr.metastorage.PitrLocalState;
import org.gridgain.internal.pitr.metastorage.PitrMetaStorageKeys;
import org.gridgain.internal.pitr.metastorage.PitrProgressDetails;
import org.gridgain.internal.pitr.metastorage.PitrStatus;

public class PitrProgress
extends PitrLocalState {
    private static final long serialVersionUID = -6437580702934505515L;
    private static final List<PitrStatus> statusPriority = List.of(PitrStatus.COMPLETED, PitrStatus.PREPARED, PitrStatus.STARTED, PitrStatus.FAILED);

    private static int priority(PitrStatus status) {
        return statusPriority.indexOf((Object)status);
    }

    private PitrProgress(PitrStatus status) {
        super(status);
    }

    public static CompletableFuture<PitrProgress> mergeLocalStates(PitrManagerContext context, UUID operationId) {
        CompletableFuture<PitrProgress> result = new CompletableFuture<PitrProgress>();
        Accumulator<Entry, PitrProgress> accumulator = new Accumulator<Entry, PitrProgress>(){
            final PitrProgress mergedState = new PitrProgress(PitrStatus.PREPARED);

            @Override
            public void accumulate(Entry item) {
                PitrLocalState local = (PitrLocalState)ByteUtils.fromBytes(item.value());
                for (Map.Entry<Integer, PitrProgressDetails> entry : local.tables().entrySet()) {
                    this.mergedState.tables().merge(entry.getKey(), entry.getValue(), PitrProgressDetails::merge);
                }
                this.mergedState.setTotal(this.mergedState.total().merge(local.total()));
                if (local.description() != null) {
                    this.mergedState.setDescription(local.description());
                }
                if (this.mergedState.status() == null || PitrProgress.priority(local.status()) > PitrProgress.priority(this.mergedState.status())) {
                    this.mergedState.setStatus(local.status());
                }
            }

            @Override
            public PitrProgress get() throws AccumulateException {
                return this.mergedState;
            }
        };
        context.metaStorageManager().prefix(PitrMetaStorageKeys.pitrLocalStatePrefix(operationId)).subscribe(accumulator.toSubscriber(result));
        return result;
    }
}

