/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite3.internal.cluster.management.raft.ValidationManager;
import org.apache.ignite3.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.eventlog.api.GridGainEventType;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.event.LicenseUpdateEventParameters;
import org.jetbrains.annotations.Nullable;

public class LicenseValidationManager
extends ValidationManager
implements EventListener<LicenseUpdateEventParameters> {
    @Nullable
    private volatile License license = null;
    private final Consumer<Event> notifier;
    private final Set<UUID> checkAfterInitializeClusterConfiguration = ConcurrentHashMap.newKeySet();

    public LicenseValidationManager(ClusterStateStorageManager storage, LogicalTopology logicalTopology, Consumer<Event> notifier) {
        super(storage, logicalTopology);
        this.notifier = notifier;
    }

    @Override
    protected ValidationResult validateNode(@Nullable ClusterState state, LogicalNode node, IgniteProductVersion version, ClusterTag clusterTag) {
        License localLicense = this.license;
        if (localLicense == null) {
            this.checkAfterInitializeClusterConfiguration.add(node.id());
        } else {
            LicenseViolationInfo violationInfo = this.verifyLicenseViolation(localLicense, node);
            if (violationInfo.hasViolations()) {
                this.logJoinDeniedEvent(localLicense, node);
                return LicenseValidationManager.joinDeniedResult(violationInfo);
            }
        }
        return super.validateNode(state, node, version, clusterTag);
    }

    @Override
    protected ValidationResult completeValidation(LogicalNode node) {
        LicenseViolationInfo violationInfo;
        License localLicense;
        if (this.checkAfterInitializeClusterConfiguration.remove(node.id()) && (localLicense = this.license) != null && (violationInfo = this.verifyLicenseViolation(localLicense, node)).hasViolations()) {
            this.logJoinDeniedEvent(localLicense, node);
            return LicenseValidationManager.joinDeniedResult(violationInfo);
        }
        return super.completeValidation(node);
    }

    @Override
    public CompletableFuture<Boolean> notify(LicenseUpdateEventParameters parameters) {
        this.license = parameters.license();
        return CompletableFutures.falseCompletedFuture();
    }

    private LicenseViolationInfo verifyLicenseViolation(License license, LogicalNode node) {
        Set<LogicalNode> newTopology = CollectionUtils.union(this.logicalTopology.getLogicalTopology().nodes(), Set.of(node));
        return LicenseValidator.verifyLicenseViolation(license, newTopology);
    }

    private static ValidationResult joinDeniedResult(LicenseViolationInfo violationInfo) {
        return ValidationResult.configErrorResult(violationInfo.formatViolationMessage());
    }

    private void logJoinDeniedEvent(License localLicense, LogicalNode node) {
        this.notifier.accept(GridGainEventType.LICENSE_NODE_REJECTED.builder().user(EventUser.system()).timestamp(System.currentTimeMillis()).fields(Map.of("licenseId", localLicense.field(HoconLicenseField.ID), "nodeId", node.id())).build());
    }
}

