/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.util.StringUtils;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.gridgain.internal.encryption.provider.configuration.KeyProviderView;
import org.gridgain.internal.encryption.utils.KeyProviderValidationUtils;
import org.gridgain.internal.encryption.validator.KeyProviderValidator;

public class KeyProviderValidatorImpl
implements Validator<KeyProviderValidator, NamedListView<? extends KeyProviderView>> {
    public static final KeyProviderValidatorImpl INSTANCE = new KeyProviderValidatorImpl();

    @Override
    public void validate(KeyProviderValidator annotation, ValidationContext<NamedListView<? extends KeyProviderView>> ctx) {
        String activeProvider;
        NamedListView<? extends KeyProviderView> view = ctx.getNewValue();
        EncryptionView encryptionView = (EncryptionView)ctx.getNewOwner();
        boolean enabled = encryptionView.enabled();
        if (enabled && view.isEmpty()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "At least one provider is required."));
        }
        if (!StringUtils.nullOrBlank(activeProvider = KeyProviderValidationUtils.normalizeProviderName(encryptionView.activeProvider())) && view.stream().noneMatch(s -> activeProvider.equals(KeyProviderValidationUtils.normalizeProviderName(s.name())))) {
            String message = "Provider \"" + activeProvider + "\" is not present in the provider configuration";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
        for (KeyProviderView keyProviderView : view) {
            String message;
            try {
                Cipher.getInstance(keyProviderView.cipher());
            }
            catch (NoSuchAlgorithmException e) {
                message = "Cipher algorithm \"" + keyProviderView.cipher() + "\" is not supported: " + e.getMessage();
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
            }
            catch (NoSuchPaddingException e) {
                message = "Cipher padding \"" + keyProviderView.cipher() + "\" is not supported: " + e.getMessage();
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
            }
        }
    }
}

