/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTableConverters;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.util.PlainTableRenderer;
import org.apache.ignite3.rest.client.model.ReplicationInfo;

public class ReplicationInfoListDecorator
implements Decorator<List<ReplicationInfo>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"name", "from", "to", "status"};
    private final boolean plain;

    public ReplicationInfoListDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(List<ReplicationInfo> data) {
        if (data == null || data.isEmpty()) {
            return () -> "";
        }
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, this.replicationContent(data));
        }
        return () -> FlipTableConverters.fromObjects((String[])HEADERS, (Object[][])this.replicationContent(data));
    }

    private String[][] replicationContent(List<ReplicationInfo> data) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int maxLength = 0;
        for (ReplicationInfo ri : data) {
            if (ri.getStatus().toString().length() <= maxLength) continue;
            maxLength = ri.getStatus().toString().length();
        }
        for (ReplicationInfo replicationInfo : data) {
            result.add(new String[]{replicationInfo.getName(), replicationInfo.getSourceClusterName(), replicationInfo.getTargetClusterName(), AnsiStringSupport.ansi(this.paintStatus(replicationInfo, maxLength))});
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }

    private String paintStatus(ReplicationInfo replicationInfo, int maxLength) {
        switch (replicationInfo.getStatus()) {
            case STOPPED: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.YELLOW).mark(ReplicationInfoListDecorator.addPadding(replicationInfo.getStatus().toString(), maxLength));
            }
            case FAILED: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.RED).mark(ReplicationInfoListDecorator.addPadding(replicationInfo.getStatus().toString(), maxLength));
            }
            case REPLICATING: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.GREEN).mark(ReplicationInfoListDecorator.addPadding(replicationInfo.getStatus().toString(), maxLength));
            }
        }
        return replicationInfo.getStatus().toString();
    }

    private static String addPadding(String string, int maxLength) {
        StringBuilder result = new StringBuilder(string);
        while (result.length() < maxLength) {
            result.append(' ');
        }
        return result.toString();
    }
}

