/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.DcrApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;

@Singleton
public class DeleteReplicationCall
implements Call<ReplicationNameCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public DeleteReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(ReplicationNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            boolean success = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).deleteReplication(input.replicationName());
            if (success) {
                return DefaultCallOutput.success("Replication " + input.replicationName() + " was deleted.");
            }
            return DefaultCallOutput.failure(new IgniteCliException("Replication " + input.replicationName() + " was not deleted."));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

