/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.sink;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Sink;
import org.gridgain.internal.cli.call.cdc.sink.SinkCallInput;

@Singleton
public class UpdateSinkCall
implements Call<SinkCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public UpdateSinkCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(SinkCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).updateSink(input.name(), new Sink().type(input.type()).name(input.name()).parameters(input.params()));
            return DefaultCallOutput.success("Sink " + input.name() + " updated.");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

