/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table;

public class NearCacheOptions {
    public static final NearCacheOptions DEFAULT = NearCacheOptions.builder().build();
    private final long maxEntries;
    private final int expireAfterAccess;
    private final int expireAfterUpdate;
    private final int updatePollInterval;

    private NearCacheOptions(long maxEntries, int expireAfterAccess, int expireAfterUpdate, int updatePollInterval) {
        this.maxEntries = maxEntries;
        this.expireAfterAccess = expireAfterAccess;
        this.expireAfterUpdate = expireAfterUpdate;
        this.updatePollInterval = updatePollInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long maxEntries() {
        return this.maxEntries;
    }

    public int expireAfterAccess() {
        return this.expireAfterAccess;
    }

    public int expireAfterUpdate() {
        return this.expireAfterUpdate;
    }

    public int updatePollInterval() {
        return this.updatePollInterval;
    }

    public String toString() {
        return "NearCacheOptions{maxEntries=" + this.maxEntries + ", expireAfterAccess=" + this.expireAfterAccess + ", expireAfterUpdate=" + this.expireAfterUpdate + ", updatePollInterval=" + this.updatePollInterval + "}";
    }

    public static class Builder {
        private long maxEntries = 0L;
        private int expireAfterAccess = 5000;
        private int expireAfterUpdate = 5000;
        private int updatePollInterval = 0;

        public Builder maxEntries(long maxEntries) {
            if (maxEntries < 0L) {
                throw new IllegalArgumentException("Maximum number of entries in cache must not be negative: " + maxEntries);
            }
            this.maxEntries = maxEntries;
            return this;
        }

        public Builder expireAfterAccess(int expireAfterAccess) {
            if (expireAfterAccess < 0) {
                throw new IllegalArgumentException("Expiration interval must not be negative: " + expireAfterAccess);
            }
            this.expireAfterAccess = expireAfterAccess;
            return this;
        }

        public Builder expireAfterUpdate(int expireAfterUpdate) {
            if (expireAfterUpdate < 0) {
                throw new IllegalArgumentException("Expiration interval must not be negative: " + expireAfterUpdate);
            }
            this.expireAfterUpdate = expireAfterUpdate;
            return this;
        }

        public Builder updatePollInterval(int updatePollInterval) {
            if (updatePollInterval < 0) {
                throw new IllegalArgumentException("Update polling interval must not be negative: " + updatePollInterval);
            }
            this.updatePollInterval = updatePollInterval;
            return this;
        }

        public NearCacheOptions build() {
            return new NearCacheOptions(this.maxEntries, this.expireAfterAccess, this.expireAfterUpdate, this.updatePollInterval);
        }
    }
}

