/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.VacuumTxStateReplicaRequest;
import org.apache.ignite3.internal.tx.message.VacuumTxStateReplicaRequestBuilder;

class VacuumTxStateReplicaRequestDeserializer
implements MessageDeserializer<VacuumTxStateReplicaRequest> {
    private final VacuumTxStateReplicaRequestBuilder msg;

    VacuumTxStateReplicaRequestDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.vacuumTxStateReplicaRequest();
    }

    @Override
    public Class<VacuumTxStateReplicaRequest> klass() {
        return VacuumTxStateReplicaRequest.class;
    }

    @Override
    public VacuumTxStateReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.vacuumTxStateReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readSet("transactionIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionIds((Set<UUID>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(VacuumTxStateReplicaRequest.class);
    }
}

