/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.table.distributed.PartitionModificationCounterFactory;
import org.apache.ignite3.internal.table.distributed.TableStatsStalenessConfiguration;

public class PartitionModificationCounter {
    private final PartitionModificationCounterFactory.SizeSupplier partitionSizeSupplier;
    private final PartitionModificationCounterFactory.StalenessConfigurationSupplier stalenessConfigurationSupplier;
    private final AtomicLong counter = new AtomicLong(0L);
    private volatile long nextMilestone;
    private volatile HybridTimestamp lastMilestoneReachedTimestamp;

    public PartitionModificationCounter(HybridTimestamp initTimestamp, PartitionModificationCounterFactory.SizeSupplier partitionSizeSupplier, PartitionModificationCounterFactory.StalenessConfigurationSupplier stalenessConfigurationSupplier) {
        Objects.requireNonNull(initTimestamp, "initTimestamp");
        Objects.requireNonNull(partitionSizeSupplier, "partitionSizeSupplier");
        Objects.requireNonNull(stalenessConfigurationSupplier, "configurationProvider");
        this.partitionSizeSupplier = partitionSizeSupplier;
        this.stalenessConfigurationSupplier = stalenessConfigurationSupplier;
        TableStatsStalenessConfiguration tableStatsStalenessConfiguration = stalenessConfigurationSupplier.get();
        this.nextMilestone = PartitionModificationCounter.computeNextMilestone(partitionSizeSupplier.get(), tableStatsStalenessConfiguration.staleRowsFraction(), tableStatsStalenessConfiguration.minStaleRowsCount());
        this.lastMilestoneReachedTimestamp = initTimestamp;
    }

    public long value() {
        return this.counter.get();
    }

    public HybridTimestamp lastMilestoneTimestamp() {
        return this.lastMilestoneReachedTimestamp;
    }

    public long nextMilestone() {
        return this.nextMilestone;
    }

    public void updateValue(int delta, HybridTimestamp commitTimestamp) {
        Objects.requireNonNull(commitTimestamp, "commitTimestamp");
        if (delta < 0) {
            throw new IllegalArgumentException("Delta must be non-negative.");
        }
        if (delta == 0) {
            return;
        }
        long newCounter = this.counter.addAndGet(delta);
        if (newCounter >= this.nextMilestone) {
            long currentSize = this.partitionSizeSupplier.get();
            TableStatsStalenessConfiguration tableStatsStalenessConfiguration = this.stalenessConfigurationSupplier.get();
            this.nextMilestone = newCounter + PartitionModificationCounter.computeNextMilestone(currentSize, tableStatsStalenessConfiguration.staleRowsFraction(), tableStatsStalenessConfiguration.minStaleRowsCount());
            this.lastMilestoneReachedTimestamp = commitTimestamp;
        }
    }

    private static long computeNextMilestone(long currentSize, double staleRowsFraction, long minStaleRowsCount) {
        return Math.max((long)((double)currentSize * staleRowsFraction), minStaleRowsCount);
    }
}

