/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.rocksdb.GcRowVersion;
import org.apache.ignite3.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

class GarbageCollector {
    private static final int GC_KEY_TS_OFFSET = 6;
    private static final int GC_KEY_ROW_ID_OFFSET = 14;
    private static final int GC_KEY_SIZE = 30;
    private static final ThreadLocal<ByteBuffer> DIRECT_DATA_ID_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final ThreadLocal<ByteBuffer> DIRECT_DATA_ID_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(24).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final ThreadLocal<ByteBuffer> DIRECT_GC_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private final PartitionDataHelper helper;
    private final RocksDB db;
    private final ColumnFamilyHandle gcQueueCf;
    private final ReadOptions readOpts;

    GarbageCollector(PartitionDataHelper helper, RocksDB db, ReadOptions readOpts, ColumnFamilyHandle gcQueueCf) {
        this.helper = helper;
        this.db = db;
        this.gcQueueCf = gcQueueCf;
        this.readOpts = readOpts;
    }

    AddResult tryAddToGcQueue(WriteBatchWithIndex writeBatch, RowId rowId, HybridTimestamp timestamp, boolean isNewValueTombstone) throws RocksDBException {
        ByteBuffer dataIdKeyBuffer = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        this.helper.putCommittedDataIdKey(dataIdKeyBuffer, rowId, timestamp);
        try (RocksIterator it = this.db.newIterator(this.helper.partCf, this.helper.upperBoundReadOpts);){
            AddResult result;
            it.seek(dataIdKeyBuffer);
            if (RocksDbMvPartitionStorage.invalid(it)) {
                AddResult addResult = AddResult.WAS_EMPTY;
                return addResult;
            }
            dataIdKeyBuffer.clear();
            int keyLen = it.key(dataIdKeyBuffer);
            RowId readRowId = this.helper.getRowId(dataIdKeyBuffer, 6);
            if (!readRowId.equals(rowId)) {
                AddResult addResult = AddResult.WAS_EMPTY;
                return addResult;
            }
            assert (keyLen == 30);
            if (GarbageCollector.isCurrentValueTombstone(it)) {
                if (isNewValueTombstone) {
                    AddResult addResult = AddResult.WAS_TOMBSTONE;
                    return addResult;
                }
                result = AddResult.WAS_TOMBSTONE;
            } else {
                result = AddResult.WAS_VALUE;
            }
            ByteBuffer gcKeyBuffer = DIRECT_GC_KEY_BUFFER.get().clear();
            this.helper.putGcKey(gcKeyBuffer, rowId, timestamp);
            writeBatch.put(this.gcQueueCf, gcKeyBuffer, RocksDbStorageUtils.EMPTY_DIRECT_BUFFER);
            AddResult addResult = result;
            return addResult;
        }
    }

    @Nullable
    GcEntry peek(WriteBatchWithIndex writeBatch, HybridTimestamp lowWatermark) {
        try (RocksIterator gcIt = this.newWrappedIterator(writeBatch, this.gcQueueCf, this.helper.upperBoundReadOpts);){
            gcIt.seek(this.helper.partitionStartPrefix());
            if (RocksDbMvPartitionStorage.invalid(gcIt)) {
                GcEntry gcEntry = null;
                return gcEntry;
            }
            ByteBuffer gcKeyBuffer = GarbageCollector.readGcKey(gcIt);
            GcRowVersion gcRowVersion = this.toGcRowVersion(gcKeyBuffer);
            if (gcRowVersion.getTimestamp().compareTo(lowWatermark) > 0) {
                GcEntry gcEntry = null;
                return gcEntry;
            }
            GcRowVersion gcRowVersion2 = gcRowVersion;
            return gcRowVersion2;
        }
    }

    @Nullable
    BinaryRow vacuum(WriteBatchWithIndex batch, GcEntry entry) throws RocksDBException {
        assert (entry instanceof GcRowVersion);
        ColumnFamilyHandle partCf = this.helper.partCf;
        try (RocksIterator gcIt = this.newWrappedIterator(batch, this.gcQueueCf, this.helper.upperBoundReadOpts);){
            BinaryRow binaryRow;
            block27: {
                ByteBuffer dataIdKey;
                RocksIterator partIt;
                block25: {
                    BinaryRow binaryRow2;
                    block26: {
                        GcRowVersion gcRowVersion;
                        block23: {
                            BinaryRow binaryRow3;
                            block24: {
                                gcIt.seek(this.helper.partitionStartPrefix());
                                if (RocksDbMvPartitionStorage.invalid(gcIt)) {
                                    BinaryRow binaryRow4 = null;
                                    return binaryRow4;
                                }
                                ByteBuffer gcKeyBuffer = GarbageCollector.readGcKey(gcIt);
                                gcRowVersion = this.toGcRowVersion(gcKeyBuffer);
                                if (!gcRowVersion.equals(entry)) {
                                    BinaryRow binaryRow5 = null;
                                    return binaryRow5;
                                }
                                batch.delete(this.gcQueueCf, gcKeyBuffer);
                                partIt = this.newWrappedIterator(batch, partCf, this.helper.upperBoundReadOpts);
                                try {
                                    boolean proceed = this.checkHasNewerRowAndRemoveTombstone(partIt, batch, gcRowVersion);
                                    if (proceed) break block23;
                                    binaryRow3 = null;
                                    if (partIt == null) break block24;
                                }
                                catch (Throwable throwable) {
                                    if (partIt != null) {
                                        try {
                                            partIt.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                partIt.close();
                            }
                            return binaryRow3;
                        }
                        dataIdKey = this.getDataIdKeyForGc(partIt, gcRowVersion.getRowId());
                        if (dataIdKey != null) break block25;
                        binaryRow2 = null;
                        if (partIt == null) break block26;
                        partIt.close();
                    }
                    return binaryRow2;
                }
                ByteBuffer dataId = GarbageCollector.readDataId(partIt);
                assert (!PartitionDataHelper.isTombstone(dataId));
                byte[] payloadKey = this.helper.createPayloadKey(dataId);
                byte[] rowBytes = PartitionDataHelper.getFromBatchAndDb(this.db, batch, this.helper.dataCf, this.readOpts, payloadKey);
                assert (rowBytes != null && rowBytes.length > 0);
                batch.delete(partCf, dataIdKey);
                batch.delete(this.helper.dataCf, payloadKey);
                binaryRow = PartitionDataHelper.deserializeRow(rowBytes);
                if (partIt == null) break block27;
                partIt.close();
            }
            return binaryRow;
        }
    }

    private boolean checkHasNewerRowAndRemoveTombstone(RocksIterator it, WriteBatchWithIndex batch, GcRowVersion gcRowVersion) throws RocksDBException {
        ByteBuffer dataIdKeyBuffer = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        this.helper.putCommittedDataIdKey(dataIdKeyBuffer, gcRowVersion.getRowId(), gcRowVersion.getTimestamp());
        it.seek(dataIdKeyBuffer);
        if (RocksDbMvPartitionStorage.invalid(it)) {
            return false;
        }
        dataIdKeyBuffer.clear();
        it.key(dataIdKeyBuffer);
        if (!this.helper.getRowId(dataIdKeyBuffer, 6).equals(gcRowVersion.getRowId())) {
            return false;
        }
        if (GarbageCollector.isCurrentValueTombstone(it)) {
            batch.delete(this.helper.partCf, dataIdKeyBuffer);
        }
        return true;
    }

    @Nullable
    private ByteBuffer getDataIdKeyForGc(RocksIterator it, RowId gcElementRowId) {
        RowId rowId;
        it.next();
        if (RocksDbMvPartitionStorage.invalid(it)) {
            return null;
        }
        ByteBuffer dataIdKeyBuffer = DIRECT_DATA_ID_KEY_BUFFER.get().clear();
        int keyLen = it.key(dataIdKeyBuffer);
        if (keyLen == 30 && gcElementRowId.equals(rowId = this.helper.getRowId(dataIdKeyBuffer, 6))) {
            return dataIdKeyBuffer;
        }
        return null;
    }

    void deleteQueue(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.deleteRange(this.gcQueueCf, this.helper.partitionStartPrefix(), this.helper.partitionEndPrefix());
    }

    private static ByteBuffer readGcKey(RocksIterator gcIt) {
        ByteBuffer gcKeyBuffer = DIRECT_GC_KEY_BUFFER.get().clear();
        gcIt.key(gcKeyBuffer);
        return gcKeyBuffer;
    }

    private GcRowVersion toGcRowVersion(ByteBuffer gcKeyBuffer) {
        return new GcRowVersion(this.helper.getRowId(gcKeyBuffer, 14), PartitionDataHelper.readTimestampNatural(gcKeyBuffer, 6));
    }

    private RocksIterator newWrappedIterator(WriteBatchWithIndex writeBatch, ColumnFamilyHandle cf, ReadOptions readOptions) {
        RocksIterator it = this.db.newIterator(cf, readOptions);
        return PartitionDataHelper.wrapIterator(it, writeBatch, cf);
    }

    private static ByteBuffer readDataId(RocksIterator it) {
        ByteBuffer dataId = DIRECT_DATA_ID_BUFFER.get().clear();
        it.value(dataId);
        return dataId;
    }

    private static boolean isCurrentValueTombstone(RocksIterator it) {
        return PartitionDataHelper.isTombstone(GarbageCollector.readDataId(it));
    }

    static enum AddResult {
        WAS_TOMBSTONE,
        WAS_VALUE,
        WAS_EMPTY;

    }
}

