/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class TableDescriptorImpl
extends NullInitializerExpressionFactory
implements TableDescriptor {
    private static final ColumnDescriptor[] DUMMY = new ColumnDescriptor[0];
    private final ColumnDescriptor[] descriptors;
    private final Map<String, ColumnDescriptor> descriptorsMap;
    private final IgniteDistribution distribution;
    private final RelDataType rowType;
    private final RelDataType rowTypeSansHidden;
    private final boolean hasHiddenColumns;
    private final boolean hasVirtualColumns;

    public TableDescriptorImpl(List<ColumnDescriptor> columnDescriptors, IgniteDistribution distribution) {
        this.distribution = distribution;
        HashMap<String, ColumnDescriptor> descriptorsMap = IgniteUtils.newHashMap(columnDescriptors.size());
        IgniteTypeFactory factory = Commons.typeFactory();
        RelDataTypeFactory.Builder typeBuilder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        RelDataTypeFactory.Builder typeSansHiddenBuilder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        boolean hasHiddenColumns = false;
        boolean hasVirtualColumns = false;
        for (ColumnDescriptor descriptor : columnDescriptors) {
            RelDataType columnType = this.deriveLogicalType((RelDataTypeFactory)factory, descriptor);
            typeBuilder.add(descriptor.name(), columnType);
            if (!descriptor.hidden()) {
                typeSansHiddenBuilder.add(descriptor.name(), columnType);
            } else {
                hasHiddenColumns = true;
            }
            if (descriptor.virtual()) {
                hasVirtualColumns = true;
            }
            descriptorsMap.put(descriptor.name(), descriptor);
        }
        this.descriptors = columnDescriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
        this.rowType = typeBuilder.build();
        this.rowTypeSansHidden = typeSansHiddenBuilder.build();
        this.hasHiddenColumns = hasHiddenColumns;
        this.hasVirtualColumns = hasVirtualColumns;
    }

    @Override
    public Iterator<ColumnDescriptor> iterator() {
        return Arrays.stream(this.descriptors).iterator();
    }

    @Override
    public IgniteDistribution distribution() {
        return this.distribution;
    }

    public ColumnStrategy generationStrategy(RelOptTable tbl, int colIdx) {
        if (this.descriptors[colIdx].virtual()) {
            return ColumnStrategy.VIRTUAL;
        }
        if (this.descriptors[colIdx].defaultStrategy() != DefaultValueStrategy.DEFAULT_NULL) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(tbl, colIdx);
    }

    public RexNode newColumnDefaultValue(RelOptTable tbl, int colIdx, InitializerContext ctx) {
        ColumnDescriptor descriptor = this.descriptors[colIdx];
        RexBuilder rexBuilder = ctx.getRexBuilder();
        switch (descriptor.defaultStrategy()) {
            case DEFAULT_NULL: {
                RelDataType fieldType = ((RelDataTypeField)tbl.getRowType().getFieldList().get(colIdx)).getType();
                return rexBuilder.makeNullLiteral(fieldType);
            }
            case DEFAULT_CONSTANT: {
                NativeType nativeType = descriptor.physicalType();
                Object defaultVal = descriptor.defaultValueProvider().get();
                Object internalValue = defaultVal == null ? defaultVal : TypeUtils.toInternal(defaultVal, nativeType.spec());
                RelDataType relDataType = this.deriveLogicalType(rexBuilder.getTypeFactory(), descriptor);
                return rexBuilder.makeLiteral(internalValue, relDataType, false);
            }
            case DEFAULT_COMPUTED: {
                if (descriptor.virtual()) {
                    return rexBuilder.makeInputRef(((RelDataTypeField)tbl.getRowType().getFieldList().get(colIdx)).getType(), colIdx);
                }
                DefaultValueProvider.FunctionalValueProvider defaultValueProvider = (DefaultValueProvider.FunctionalValueProvider)descriptor.defaultValueProvider();
                SqlOperator operator = TableDescriptorImpl.getSqlOperatorByFunctionName(defaultValueProvider.name());
                RexNode[] params = (RexNode[])defaultValueProvider.parameters().stream().skip(1L).map(x -> rexBuilder.makeLiteral(x, rexBuilder.getTypeFactory().createJavaType(x.getClass()))).toArray(RexNode[]::new);
                return rexBuilder.makeCall(operator, params);
            }
        }
        throw new IllegalStateException("Unknown default strategy: " + descriptor.defaultStrategy());
    }

    private static SqlOperator getSqlOperatorByFunctionName(String functionName) {
        switch (functionName) {
            case "RAND_UUID": {
                return IgniteSqlOperatorTable.RAND_UUID;
            }
            case "CURRENT_TIMESTAMP_PLUS_INTERVAL": {
                return GridgainSqlOperatorTable.CURRENT_TIMESTAMP_PLUS_INTERVAL;
            }
            case "CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL": {
                return GridgainSqlOperatorTable.CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL;
            }
            case "NEXTVAL": {
                return GridgainSqlOperatorTable.NEXTVAL;
            }
        }
        throw new IllegalStateException("Unknown function name: " + functionName);
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, @Nullable ImmutableIntList usedColumns) {
        if (usedColumns == null) {
            return this.rowType;
        }
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        List fieldList = this.rowType.getFieldList();
        Iterator iterator = usedColumns.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            builder.add((RelDataTypeField)fieldList.get(i));
        }
        return builder.build();
    }

    @Override
    public RelDataType rowTypeSansHidden() {
        return this.rowTypeSansHidden;
    }

    @Override
    public ColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : this.descriptorsMap.get(fieldName);
    }

    @Override
    public ColumnDescriptor columnDescriptor(int idx) {
        return idx < 0 || idx >= this.descriptors.length ? null : this.descriptors[idx];
    }

    @Override
    public int columnsCount() {
        return this.descriptors.length;
    }

    @Override
    public boolean hasHiddenColumns() {
        return this.hasHiddenColumns;
    }

    @Override
    public boolean hasVirtualColumns() {
        return this.hasVirtualColumns;
    }

    @Override
    public TableDescriptor cloneWithNewDistribution(IgniteDistribution distribution) {
        return new TableDescriptorImpl(Arrays.asList(this.descriptors), distribution);
    }

    private RelDataType deriveLogicalType(RelDataTypeFactory factory, ColumnDescriptor desc) {
        return TypeUtils.native2relationalType(factory, desc.physicalType(), desc.nullable());
    }
}

