/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.rel.IgniteAggregate;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScanWithAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite3.internal.sql.engine.rule.ImmutableTableScanWithAggregateRule;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.immutables.value.Value;

@Value.Enclosing
public class TableScanWithAggregateRule
extends RelRule<Config> {
    public static final TableScanWithAggregateRule INSTANCE = Config.DEFAULT.toRule();

    private TableScanWithAggregateRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteAggregate aggr = (IgniteAggregate)call.rel(0);
        IgniteTableScan scan = (IgniteTableScan)call.rel(1);
        if (!scan.useSecondaryStorage() || scan.condition() != null || scan.projects() != null || aggr.getAggCallList().isEmpty() || !aggr.getAggCallList().stream().allMatch(a -> a.getAggregation().getKind() == SqlKind.MIN || a.getAggregation().getKind() == SqlKind.MAX)) {
            return;
        }
        List<AggregateCall> aggregateCalls = aggr.getAggCallList();
        RelOptCluster cluster = scan.getCluster();
        RelTraitSet traits = scan.getTraitSet();
        RelOptTable targetTable = scan.getTable();
        ImmutableBitSet groupingColumns = aggr.getGroupSet();
        ImmutableList hints = scan.getHints();
        ImmutableIntList requiredColumns = scan.requiredColumns();
        if (requiredColumns != null) {
            RelDataType rowType = ((IgniteTable)targetTable.unwrap(IgniteTable.class)).getRowType((RelDataTypeFactory)Commons.typeFactory(scan.getCluster()));
            List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
            Mapping mapping = Commons.trimmingMapping(types.size(), ImmutableBitSet.of((ImmutableIntList)requiredColumns)).inverse();
            aggregateCalls = Commons.transform(aggregateCalls, aggCall -> aggCall.transform((Mappings.TargetMapping)mapping));
            groupingColumns = Mappings.apply((Mapping)mapping, (ImmutableBitSet)groupingColumns);
        }
        IgniteTableScanWithAggregate res = new IgniteTableScanWithAggregate(cluster, traits, (List<RelHint>)hints, targetTable, aggregateCalls, groupingColumns);
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableTableScanWithAggregateRule.Config.of().withDescription("TableScanWithAggregateRule").withOperandSupplier(r -> r.operand(IgniteColocatedHashAggregate.class).oneInput(i -> i.operand(IgniteTableScan.class).noInputs()));

        default public TableScanWithAggregateRule toRule() {
            return new TableScanWithAggregateRule(this);
        }
    }
}

