/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.Pair;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.metrics.sources.ThreadPoolMetricSource;
import org.apache.ignite3.internal.sql.ColumnMetadataImpl;
import org.apache.ignite3.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite3.internal.sql.configuration.distributed.SqlDistributedConfiguration;
import org.apache.ignite3.internal.sql.configuration.local.SqlLocalConfiguration;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.kill.KillCommand;
import org.apache.ignite3.internal.sql.engine.prepare.CacheKey;
import org.apache.ignite3.internal.sql.engine.prepare.CopyPlan;
import org.apache.ignite3.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite3.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite3.internal.sql.engine.prepare.KeyValueGetPlan;
import org.apache.ignite3.internal.sql.engine.prepare.KeyValueModifyPlan;
import org.apache.ignite3.internal.sql.engine.prepare.KillPlan;
import org.apache.ignite3.internal.sql.engine.prepare.LazyResultSetMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite3.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.ParameterType;
import org.apache.ignite3.internal.sql.engine.prepare.PlanId;
import org.apache.ignite3.internal.sql.engine.prepare.PlannerHelper;
import org.apache.ignite3.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite3.internal.sql.engine.prepare.PreparedPlan;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.sql.engine.prepare.RbacDdlPlan;
import org.apache.ignite3.internal.sql.engine.prepare.RelWithSources;
import org.apache.ignite3.internal.sql.engine.prepare.SelectCountPlan;
import org.apache.ignite3.internal.sql.engine.prepare.ShowPlan;
import org.apache.ignite3.internal.sql.engine.prepare.ValidationResult;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyCommand;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationSelect;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopySqlToCommandConverter;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.DdlSqlToCommandConverter;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.rbac.RbacDdlSqlToCommandConverter;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadataExtractor;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadataExtractor;
import org.apache.ignite3.internal.sql.engine.prepare.show.QuerySqlToShowCommandConverter;
import org.apache.ignite3.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScanWithAggregate;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSchemas;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlExplain;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlExplainMode;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlKill;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.sql.SqlShow;
import org.apache.ignite3.internal.sql.engine.sql.copy.GridgainSqlCopy;
import org.apache.ignite3.internal.sql.engine.sql.rbac.GridgainSqlRbacDdl;
import org.apache.ignite3.internal.sql.engine.statistic.StatisticUpdatesNotifier;
import org.apache.ignite3.internal.sql.engine.util.Cloner;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.sql.metrics.SqlPlanCacheMetricSource;
import org.apache.ignite3.internal.sql.metrics.SqlQueryMetricSource;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlException;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.QualifiedNameHelper;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PrepareServiceImpl
implements PrepareService {
    private static final IgniteLogger LOG = Loggers.forClass(PrepareServiceImpl.class);
    private static final ResultSetMetadata DML_METADATA = new ResultSetMetadataImpl(List.of(new ColumnMetadataImpl("ROWCOUNT", ColumnType.INT64, -1, Integer.MIN_VALUE, false, null)));
    private static final ParameterMetadata EMPTY_PARAMETER_METADATA = new ParameterMetadata(Collections.emptyList());
    private static final long THREAD_TIMEOUT_MS = 60000L;
    private static final String PLANNING_EXECUTOR_SOURCE_NAME = "thread.pools.sql-planning-executor";
    public static final int PLAN_UPDATER_INITIAL_DELAY = 2000;
    private final UUID prepareServiceId = UUID.randomUUID();
    private final AtomicLong planIdGen = new AtomicLong();
    private final DdlSqlToCommandConverter ddlConverter;
    private final QuerySqlToShowCommandConverter showConverter;
    private final CopySqlToCommandConverter copyConverter;
    final Cache<CacheKey, CompletableFuture<PlanInfo>> cache;
    private final String nodeName;
    private final long plannerTimeout;
    private final int plannerThreadCount;
    private final MetricManager metricManager;
    private final SqlPlanCacheMetricSource sqlPlanCacheMetricSource;
    private final SqlSchemaManager schemaManager;
    private final RbacDdlSqlToCommandConverter rbacDdlConverter = new RbacDdlSqlToCommandConverter();
    private volatile ThreadPoolExecutor planningPool;
    private final PlanUpdater planUpdater;
    private final LongSupplier currentClock;

    public static PrepareServiceImpl create(String nodeName, CacheFactory cacheFactory, QuerySqlToShowCommandConverter showConverter, CopySqlToCommandConverter copyConverter, MetricManager metricManager, SqlDistributedConfiguration clusterCfg, SqlLocalConfiguration nodeCfg, SqlSchemaManager schemaManager, DdlSqlToCommandConverter ddlSqlToCommandConverter, SqlQueryMetricSource queryMetricSource, LongSupplier currentClock, ScheduledExecutorService scheduler, StatisticUpdatesNotifier updNotifier) {
        PrepareServiceImpl impl = new PrepareServiceImpl(nodeName, (Integer)clusterCfg.planner().estimatedNumberOfQueries().value(), cacheFactory, ddlSqlToCommandConverter, showConverter, copyConverter, (Long)clusterCfg.planner().maxPlanningTimeMillis().value(), (Integer)nodeCfg.planner().threadCount().value(), (Integer)clusterCfg.planner().planCacheExpiresAfterSeconds().value(), metricManager, schemaManager, currentClock, scheduler);
        updNotifier.changesNotifier(impl::statisticsChanged);
        return impl;
    }

    public PrepareServiceImpl(String nodeName, int cacheSize, CacheFactory cacheFactory, DdlSqlToCommandConverter ddlConverter, QuerySqlToShowCommandConverter showConverter, CopySqlToCommandConverter copyConverter, long plannerTimeout, int plannerThreadCount, int planExpirySeconds, MetricManager metricManager, SqlSchemaManager schemaManager, LongSupplier currentClock, ScheduledExecutorService scheduler) {
        this.nodeName = nodeName;
        this.ddlConverter = ddlConverter;
        this.showConverter = showConverter;
        this.copyConverter = copyConverter;
        this.plannerTimeout = plannerTimeout;
        this.metricManager = metricManager;
        this.plannerThreadCount = plannerThreadCount;
        this.schemaManager = schemaManager;
        this.currentClock = currentClock;
        this.sqlPlanCacheMetricSource = new SqlPlanCacheMetricSource();
        this.cache = cacheFactory.create(cacheSize, this.sqlPlanCacheMetricSource, Duration.ofSeconds(planExpirySeconds));
        this.planUpdater = new PlanUpdater(scheduler, this.cache, plannerTimeout, this::recalculatePlan, this::directCatalogVersion, this::getDefaultSchema);
    }

    @Override
    public void start() {
        this.planningPool = new ThreadPoolExecutor(this.plannerThreadCount, this.plannerThreadCount, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(this.nodeName, "sql-planning-pool", LOG, ThreadOperation.NOTHING_ALLOWED));
        this.planningPool.allowCoreThreadTimeOut(true);
        this.metricManager.registerSource(this.sqlPlanCacheMetricSource);
        this.metricManager.enable(this.sqlPlanCacheMetricSource);
        this.metricManager.registerSource(new ThreadPoolMetricSource(PLANNING_EXECUTOR_SOURCE_NAME, null, this.planningPool));
        this.metricManager.enable(PLANNING_EXECUTOR_SOURCE_NAME);
        IgnitePlanner.warmup();
        this.planUpdater.start();
    }

    @Override
    public void stop() throws Exception {
        this.planningPool.shutdownNow();
        this.metricManager.unregisterSource(this.sqlPlanCacheMetricSource);
        this.metricManager.unregisterSource(PLANNING_EXECUTOR_SOURCE_NAME);
    }

    @Override
    public CompletableFuture<QueryPlan> prepareAsync(ParsedResult parsedResult, SqlOperationContext operationContext) {
        String schemaName = operationContext.defaultSchemaName();
        assert (schemaName != null);
        boolean explicitTx = operationContext.txContext() != null && operationContext.txContext().explicitTx() != null;
        long timestamp = operationContext.operationTime().longValue();
        int catalogVersion = this.schemaManager.catalogVersion(timestamp);
        CacheKey key = PrepareServiceImpl.createCacheKey(parsedResult.normalizedQuery(), catalogVersion, schemaName, operationContext.parameters());
        CompletableFuture<PlanInfo> planFuture = this.cache.get(key);
        if (planFuture != null) {
            return planFuture.thenApply(plan -> {
                if (!(plan.queryPlan instanceof MultiStepPlan)) {
                    return plan.queryPlan;
                }
                MultiStepPlan regularPlan = (MultiStepPlan)plan.queryPlan;
                QueryPlan fastPlan = regularPlan.fastPlan();
                if (fastPlan != null && !explicitTx) {
                    return fastPlan;
                }
                return regularPlan;
            });
        }
        SchemaPlus defaultSchema = this.getDefaultSchema(catalogVersion, schemaName);
        PlanningContext planningContext = PlanningContext.builder().frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(defaultSchema).build()).query(parsedResult.originalQuery()).plannerTimeout(this.plannerTimeout).catalogVersion(catalogVersion).defaultSchemaName(schemaName).parameters(Commons.arrayToMap(key.paramTypes())).explicitTx(explicitTx).build();
        return this.prepareAsync0(parsedResult, planningContext).exceptionally(ex -> {
            Throwable th = ExceptionUtils.unwrapCause(ex);
            throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(th));
        });
    }

    private static CacheKey createCacheKey(String query, int catalogVersion, String schemaName, Object[] params) {
        ColumnType[] paramTypes = new ColumnType[params.length];
        int idx = 0;
        for (Object param : params) {
            ColumnType columnType;
            if (param != null) {
                @Nullable NativeType type = NativeTypes.fromObject(param);
                if (type == null) {
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unsupported native type: " + param.getClass());
                }
                columnType = type.spec();
            } else {
                columnType = null;
            }
            paramTypes[idx++] = columnType;
        }
        return new CacheKey(catalogVersion, schemaName, query, paramTypes);
    }

    private SchemaPlus getDefaultSchema(int catalogVersion, String schemaName) {
        IgniteSchemas rootSchema = this.schemaManager.schemas(catalogVersion);
        assert (rootSchema != null) : "Root schema does not exist";
        SchemaPlus schemaPlus = rootSchema.root();
        SchemaPlus defaultSchema = schemaPlus.getSubSchema(schemaName);
        if (defaultSchema == null) {
            defaultSchema = schemaPlus;
        }
        return defaultSchema;
    }

    @Override
    public CompletableFuture<Void> invalidateCache(Set<String> tableNames) {
        return CompletableFuture.supplyAsync(() -> {
            if (tableNames.isEmpty()) {
                this.cache.clear();
            } else {
                Set qualifiedNames = tableNames.stream().map(QualifiedName::parse).collect(Collectors.toSet());
                this.cache.removeIfValue(p -> {
                    if (!p.isDone()) return false;
                    if (!PrepareServiceImpl.planMatches(((PlanInfo)p.join()).queryPlan, qualifiedNames::contains)) return false;
                    return true;
                });
            }
            return null;
        }, this.planningPool);
    }

    @Override
    public Set<PreparedPlan> preparedPlans() {
        return this.cache.entrySet().stream().filter(e -> {
            CompletableFuture f = (CompletableFuture)e.getValue();
            return f.isDone() && !f.isCompletedExceptionally() && !f.isCancelled();
        }).map(e -> {
            CacheKey key = (CacheKey)e.getKey();
            PlanInfo value = ((CompletableFuture)e.getValue()).getNow(null);
            Instant timestamp = value.timestamp;
            return new PreparedPlan(key, value.queryPlan, timestamp);
        }).collect(Collectors.toSet());
    }

    @TestOnly
    UUID prepareServiceId() {
        return this.prepareServiceId;
    }

    public static boolean planMatches(QueryPlan plan, Predicate<QualifiedName> predicate) {
        assert (plan instanceof ExplainablePlan);
        MatchingShuttle shuttle = new MatchingShuttle(predicate);
        ((ExplainablePlan)plan).getRel().accept(shuttle);
        return shuttle.matches();
    }

    private CompletableFuture<QueryPlan> prepareAsync0(ParsedResult parsedResult, PlanningContext planningContext) {
        switch (parsedResult.queryType()) {
            case QUERY: {
                return this.prepareQuery(parsedResult, planningContext).thenApply(f -> f.queryPlan);
            }
            case SHOW: {
                return this.prepareShow(parsedResult, planningContext);
            }
            case COPY: {
                return this.prepareCopy(parsedResult, planningContext);
            }
            case DDL: {
                return this.prepareDdl(parsedResult, planningContext);
            }
            case RBAC_DDL: {
                return this.prepareRbacDdl(parsedResult, planningContext);
            }
            case KILL: {
                return this.prepareKill(parsedResult);
            }
            case DML: {
                return this.prepareDml(parsedResult, planningContext).thenApply(f -> f.queryPlan);
            }
            case EXPLAIN: {
                return this.prepareExplain(parsedResult, planningContext);
            }
        }
        throw new AssertionError((Object)("Unexpected queryType=" + parsedResult.queryType()));
    }

    private CompletableFuture<QueryPlan> prepareCopy(ParsedResult parsedResult, PlanningContext ctx) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof GridgainSqlCopy) : sqlNode.getClass().getName();
        GridgainSqlCopy sqlCopy = (GridgainSqlCopy)sqlNode;
        CopyCommand cmd = this.copyConverter.convert(sqlCopy, ctx);
        if (cmd.from() instanceof CopyLocationSelect) {
            CopyLocationSelect location = (CopyLocationSelect)cmd.from();
            ParsedResultImpl selectParsed = new ParsedResultImpl(SqlQueryType.QUERY, parsedResult.originalQuery(), location.selectNode().toString(), parsedResult.dynamicParamsCount(), (SqlNode)location.selectNode());
            return this.prepareAsync0(selectParsed, ctx).thenApply(selectPlan -> {
                location.plan((QueryPlan)selectPlan);
                return new CopyPlan(this.nextPlanId(), cmd);
            });
        }
        return CompletableFuture.completedFuture(new CopyPlan(this.nextPlanId(), cmd));
    }

    private CompletableFuture<QueryPlan> prepareShow(ParsedResult parsedResult, PlanningContext planningContext) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof SqlShow) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        SqlShow sqlShow = (SqlShow)sqlNode;
        return CompletableFuture.completedFuture(new ShowPlan(this.nextPlanId(), this.showConverter.convert(sqlShow, planningContext), this.showConverter.convertMetadata(sqlShow, planningContext)));
    }

    private CompletableFuture<QueryPlan> prepareDdl(ParsedResult parsedResult, PlanningContext ctx) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof SqlDdl) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return this.ddlConverter.convert((SqlDdl)sqlNode, ctx).thenApply(command -> new DdlPlan(this.nextPlanId(), (CatalogCommand)command));
    }

    private CompletableFuture<QueryPlan> prepareRbacDdl(ParsedResult parsedResult, PlanningContext ctx) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof GridgainSqlRbacDdl) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return CompletableFuture.completedFuture(new RbacDdlPlan(this.nextPlanId(), this.rbacDdlConverter.convert((GridgainSqlRbacDdl)sqlNode, ctx.query())));
    }

    private CompletableFuture<QueryPlan> prepareKill(ParsedResult parsedResult) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof IgniteSqlKill) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return CompletableFuture.completedFuture(new KillPlan(this.nextPlanId(), KillCommand.fromSqlCall((IgniteSqlKill)sqlNode)));
    }

    private CompletableFuture<QueryPlan> prepareExplain(ParsedResult parsedResult, PlanningContext ctx) {
        CompletableFuture<PlanInfo> result;
        SqlNode parsedTree = parsedResult.parsedTree();
        assert (PrepareServiceImpl.single(parsedTree));
        assert (parsedTree instanceof IgniteSqlExplain) : parsedTree.getClass().getCanonicalName();
        IgniteSqlExplain parsedTree0 = (IgniteSqlExplain)parsedTree;
        SqlNode explicandum = parsedTree0.getExplicandum();
        SqlNode explainMode = parsedTree0.getMode();
        SqlQueryType queryType = Commons.getQueryType(explicandum);
        if (queryType == null) {
            return CompletableFuture.failedFuture(new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "Failed to parse query: Unexpected node in EXPLAIN statement " + explicandum.getKind()));
        }
        if (!queryType.supportsExplain()) {
            return CompletableFuture.failedFuture(new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "Failed to parse query: Incorrect syntax near the keyword " + queryType));
        }
        ParsedResultImpl newParsedResult = new ParsedResultImpl(queryType, parsedResult.originalQuery(), explicandum.toString(), parsedResult.dynamicParamsCount(), explicandum);
        switch (queryType) {
            case QUERY: {
                result = this.prepareQuery(newParsedResult, ctx);
                break;
            }
            case DML: {
                result = this.prepareDml(newParsedResult, ctx);
                break;
            }
            default: {
                throw new AssertionError((Object)"should not get here");
            }
        }
        return result.thenApply(plan -> {
            QueryPlan queryPlan = plan.queryPlan;
            assert (queryPlan instanceof ExplainablePlan) : queryPlan == null ? "<null>" : queryPlan.getClass().getCanonicalName();
            SqlLiteral literal = (SqlLiteral)explainMode;
            IgniteSqlExplainMode mode = (IgniteSqlExplainMode)literal.symbolValue(IgniteSqlExplainMode.class);
            assert (mode != null);
            return new ExplainPlan(this.nextPlanId(), (ExplainablePlan)queryPlan, mode);
        });
    }

    private static boolean single(SqlNode sqlNode) {
        return !(sqlNode instanceof SqlNodeList);
    }

    private CompletableFuture<PlanInfo> prepareQuery(ParsedResult parsedResult, PlanningContext ctx) {
        return this.validateQuery(parsedResult, ctx).thenCompose(stmt -> {
            QueryPlan fastPlan;
            if (!ctx.explicitTx() && (fastPlan = this.tryOptimizeFast((ValidStatement<ValidationResult>)stmt, ctx)) != null) {
                return CompletableFuture.completedFuture(PlanInfo.create(fastPlan));
            }
            CacheKey cacheKey = PrepareServiceImpl.createCacheKeyFromParameterMetadata(stmt.parsedResult.normalizedQuery(), ctx.catalogVersion(), ctx.schemaName(), stmt.parameterMetadata);
            return this.cache.get(cacheKey, k -> CompletableFuture.supplyAsync(() -> this.buildQueryPlan((ValidStatement<ValidationResult>)stmt, ctx, () -> this.cache.invalidate(cacheKey)), this.planningPool));
        });
    }

    private static CacheKey createCacheKeyFromParameterMetadata(String query, int catalogVersion, String schemaName, ParameterMetadata parameterMetadata) {
        ColumnType[] paramTypes;
        List<ParameterType> parameterTypes = parameterMetadata.parameterTypes();
        if (parameterTypes.isEmpty()) {
            paramTypes = CacheKey.EMPTY_CLASS_ARRAY;
        } else {
            ColumnType[] result = new ColumnType[parameterTypes.size()];
            for (int i = 0; i < parameterTypes.size(); ++i) {
                result[i] = parameterTypes.get(i).columnType();
            }
            paramTypes = result;
        }
        return new CacheKey(catalogVersion, schemaName, query, paramTypes);
    }

    private CompletableFuture<Void> rebuildQueryPlan(ParsedResult parsedResult, PlanningContext ctx, CacheKey key) {
        CompletionStage fut = this.validateQuery(parsedResult, ctx).thenCompose(stmt -> CompletableFuture.supplyAsync(() -> this.buildQueryPlan((ValidStatement<ValidationResult>)stmt, ctx, () -> {}), this.planningPool));
        return ((CompletableFuture)fut).handle((info, err) -> {
            if (err != null) {
                LOG.debug("Failed to re-planning query: " + parsedResult.originalQuery(), (Throwable)err);
            } else {
                this.cache.compute(key, (k, v) -> v == null ? null : CompletableFuture.completedFuture(info));
            }
            return null;
        });
    }

    private CompletableFuture<ValidStatement<ValidationResult>> validateQuery(ParsedResult parsedResult, PlanningContext ctx) {
        return CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode sqlNode = parsedResult.parsedTree();
            assert (PrepareServiceImpl.single(sqlNode));
            ValidationResult validated = planner.validateAndGetTypeMetadata(sqlNode);
            ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(planner.getParameterRowType());
            return new ValidStatement<ValidationResult>(parsedResult, validated, parameterMetadata);
        }, this.planningPool);
    }

    private PlanInfo buildQueryPlan(ValidStatement<ValidationResult> stmt, PlanningContext ctx, Runnable onTimeoutAction) {
        IgnitePlanner planner = ctx.planner();
        ValidationResult validated = (ValidationResult)stmt.value;
        SqlNode validatedNode = validated.sqlNode();
        RelWithMetadata relWithMetadata = this.doOptimize(ctx, validatedNode, planner, onTimeoutAction);
        IgniteRel optimizedRel = relWithMetadata.rel;
        QueryPlan fastPlan = this.tryOptimizeFast(stmt, ctx);
        ResultSetMetadata resultSetMetadata = PrepareServiceImpl.resultSetMetadata(validated.dataType(), validated.origins(), validated.aliases());
        int catalogVersion = ctx.catalogVersion();
        CacheLookupRelVisitor visitor = new CacheLookupRelVisitor();
        visitor.validate(optimizedRel);
        if (optimizedRel instanceof IgniteKeyValueGet) {
            IgniteKeyValueGet kvGet = (IgniteKeyValueGet)optimizedRel;
            KeyValueGetPlan plan = new KeyValueGetPlan(this.nextPlanId(), catalogVersion, kvGet, resultSetMetadata, stmt.parameterMetadata, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.caches);
            return PlanInfo.create(plan);
        }
        MultiStepPlan plan = new MultiStepPlan(this.nextPlanId(), SqlQueryType.QUERY, optimizedRel, resultSetMetadata, stmt.parameterMetadata, catalogVersion, relWithMetadata.numSources, fastPlan, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.tables, visitor.caches);
        PrepareServiceImpl.logPlan(stmt.parsedResult().originalQuery(), plan);
        int currentCatalogVersion = this.directCatalogVersion();
        if (currentCatalogVersion == catalogVersion) {
            IntSet sources = PrepareServiceImpl.resolveSources(plan.getRel());
            return PlanInfo.createRefreshable(plan, stmt, sources);
        }
        return PlanInfo.create(plan);
    }

    private CompletableFuture<Void> recalculatePlan(SqlQueryType queryType, ParsedResult parsedRes, PlanningContext ctx, CacheKey key) {
        int currentCatalogVersion = this.directCatalogVersion();
        if (currentCatalogVersion != key.catalogVersion()) {
            return CompletableFuture.completedFuture(null);
        }
        if (queryType == SqlQueryType.QUERY) {
            return this.rebuildQueryPlan(parsedRes, ctx, key);
        }
        if (queryType == SqlQueryType.DML) {
            return this.rebuildDmlPlan(parsedRes, ctx, key);
        }
        throw new AssertionError((Object)"should not get here");
    }

    private PlanId nextPlanId() {
        return new PlanId(this.prepareServiceId, this.planIdGen.getAndIncrement());
    }

    private static boolean simpleInsert(SqlNode node) {
        if (!(node instanceof SqlInsert)) {
            return false;
        }
        SqlInsert insert = (SqlInsert)node;
        SqlNode sourceNode = insert.getSource();
        if (!(sourceNode instanceof SqlBasicCall) || insert.isUpsert() || sourceNode.getKind() != SqlKind.VALUES) {
            return false;
        }
        for (SqlNode op : ((SqlBasicCall)sourceNode).getOperandList()) {
            if (!(op instanceof SqlBasicCall)) {
                return false;
            }
            SqlBasicCall opCall = (SqlBasicCall)op;
            for (SqlNode op0 : opCall.getOperandList()) {
                if (op0.getKind() == SqlKind.LITERAL) continue;
                return false;
            }
        }
        return true;
    }

    CompletableFuture<PlanInfo> prepareDmlOpt(SqlNode sqlNode, PlanningContext ctx, String originalQuery) {
        assert (PrepareServiceImpl.single(sqlNode));
        IgnitePlanner planner = ctx.planner();
        SqlNode validatedNode = planner.validate(sqlNode);
        RelWithMetadata relWithMetadata = this.doOptimize(ctx, validatedNode, planner, null);
        IgniteRel optimizedRel = relWithMetadata.rel;
        CacheLookupRelVisitor visitor = new CacheLookupRelVisitor();
        visitor.validate(optimizedRel);
        RelDataType parameterRowType = planner.getParameterRowType();
        ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(parameterRowType);
        ExplainablePlan plan = optimizedRel instanceof IgniteKeyValueModify ? new KeyValueModifyPlan(this.nextPlanId(), ctx.catalogVersion(), (IgniteKeyValueModify)optimizedRel, DML_METADATA, parameterMetadata, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.caches) : new MultiStepPlan(this.nextPlanId(), SqlQueryType.DML, optimizedRel, DML_METADATA, parameterMetadata, ctx.catalogVersion(), relWithMetadata.numSources, null, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.tables, visitor.caches);
        PrepareServiceImpl.logPlan(originalQuery, plan);
        return CompletableFuture.completedFuture(PlanInfo.create(plan));
    }

    private CompletableFuture<Void> rebuildDmlPlan(ParsedResult parsedResult, PlanningContext ctx, CacheKey key) {
        CompletionStage fut = this.validateDml(parsedResult, parsedResult.parsedTree(), ctx).thenCompose(stmt -> CompletableFuture.supplyAsync(() -> this.buildDmlPlan((ValidStatement<ValidationResult>)stmt, ctx, () -> {}), this.planningPool));
        return ((CompletableFuture)fut).handle((info, err) -> {
            if (err != null) {
                LOG.debug("Failed to re-planning query: " + parsedResult.originalQuery(), (Throwable)err);
            } else {
                this.cache.compute(key, (k, v) -> v == null ? null : CompletableFuture.completedFuture(info));
            }
            return null;
        });
    }

    private CompletableFuture<PlanInfo> prepareDml(ParsedResult parsedResult, PlanningContext ctx) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (PrepareServiceImpl.single(sqlNode));
        boolean dmlSimplePlan = PrepareServiceImpl.simpleInsert(sqlNode);
        if (dmlSimplePlan) {
            return this.prepareDmlOpt(sqlNode, ctx, parsedResult.originalQuery());
        }
        return this.validateDml(parsedResult, sqlNode, ctx).thenCompose(stmt -> {
            CacheKey cacheKey = PrepareServiceImpl.createCacheKeyFromParameterMetadata(stmt.parsedResult.normalizedQuery(), ctx.catalogVersion(), ctx.schemaName(), stmt.parameterMetadata);
            return this.cache.get(cacheKey, k -> CompletableFuture.supplyAsync(() -> this.buildDmlPlan((ValidStatement<ValidationResult>)stmt, ctx, () -> this.cache.invalidate(cacheKey)), this.planningPool));
        });
    }

    private PlanInfo buildDmlPlan(ValidStatement<ValidationResult> stmt, PlanningContext ctx, Runnable onTimeoutAction) {
        ExplainablePlan plan;
        IgnitePlanner planner = ctx.planner();
        SqlNode validatedNode = ((ValidationResult)stmt.value).sqlNode();
        RelWithMetadata relWithMetadata = this.doOptimize(ctx, validatedNode, planner, onTimeoutAction);
        IgniteRel optimizedRel = relWithMetadata.rel;
        CacheLookupRelVisitor visitor = new CacheLookupRelVisitor();
        visitor.validate(optimizedRel);
        int catalogVersion = ctx.catalogVersion();
        if (optimizedRel instanceof IgniteKeyValueModify) {
            IgniteKeyValueModify kvModify = (IgniteKeyValueModify)optimizedRel;
            plan = new KeyValueModifyPlan(this.nextPlanId(), catalogVersion, kvModify, DML_METADATA, stmt.parameterMetadata, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.caches);
        } else {
            plan = new MultiStepPlan(this.nextPlanId(), SqlQueryType.DML, optimizedRel, DML_METADATA, stmt.parameterMetadata, catalogVersion, relWithMetadata.numSources, null, relWithMetadata.paMetadata, relWithMetadata.ppMetadata, visitor.tables, visitor.caches);
        }
        PrepareServiceImpl.logPlan(stmt.parsedResult().originalQuery(), plan);
        int currentCatalogVersion = this.directCatalogVersion();
        if (currentCatalogVersion == catalogVersion) {
            IntSet sources = PrepareServiceImpl.resolveSources(plan.getRel());
            return PlanInfo.createRefreshable(plan, stmt, sources);
        }
        return PlanInfo.create(plan);
    }

    private CompletableFuture<ValidStatement<ValidationResult>> validateDml(ParsedResult parsedResult, SqlNode sqlNode, PlanningContext ctx) {
        return CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode validatedNode = planner.validate(sqlNode);
            ValidationResult validatedResult = new ValidationResult(validatedNode);
            ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(planner.getParameterRowType());
            return new ValidStatement<ValidationResult>(parsedResult, validatedResult, parameterMetadata);
        }, this.planningPool);
    }

    @Nullable
    private QueryPlan tryOptimizeFast(ValidStatement<ValidationResult> stmt, PlanningContext planningContext) {
        if (!Commons.fastQueryOptimizationEnabled()) {
            return null;
        }
        Pair<IgniteRel, List<String>> relAndAliases = PlannerHelper.tryOptimizeSelectCount(planningContext.planner(), ((ValidationResult)stmt.value).sqlNode());
        if (relAndAliases == null) {
            return null;
        }
        IgniteRel fastOptRel = (IgniteRel)relAndAliases.left;
        List aliases = (List)relAndAliases.right;
        assert (fastOptRel != null);
        assert (aliases != null);
        RelDataType rowType = fastOptRel.getRowType();
        ResultSetMetadata resultSetMetadata = PrepareServiceImpl.resultSetMetadata(rowType, null, aliases);
        if (!(fastOptRel instanceof IgniteSelectCount)) {
            throw new IllegalStateException("Unexpected optimized node: " + fastOptRel);
        }
        SelectCountPlan plan = new SelectCountPlan(this.nextPlanId(), planningContext.catalogVersion(), (IgniteSelectCount)fastOptRel, resultSetMetadata, stmt.parameterMetadata);
        PrepareServiceImpl.logPlan(stmt.parsedResult.originalQuery(), plan);
        return plan;
    }

    private static IntSet resolveSources(IgniteRel rel) {
        IntOpenHashSet tables = new IntOpenHashSet();
        IgniteRelShuttle shuttle = new IgniteRelShuttle((IntSet)tables){
            final /* synthetic */ IntSet val$tables;
            {
                this.val$tables = intSet;
            }

            @Override
            public IgniteRel visit(IgniteTableModify rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.val$tables.add(igniteTable.id());
                return super.visit(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.val$tables.add(igniteTable.id());
                return rel;
            }

            @Override
            public IgniteRel visit(IgniteIndexScan rel) {
                IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                this.val$tables.add(igniteTable.id());
                return rel;
            }
        };
        shuttle.visit(rel);
        return tables;
    }

    private static ResultSetMetadata resultSetMetadata(RelDataType rowType, @Nullable List<List<String>> origins, List<String> aliases) {
        return new LazyResultSetMetadata(() -> {
            ArrayList<ColumnMetadata> fieldsMeta = new ArrayList<ColumnMetadata>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                RelDataTypeField fld = (RelDataTypeField)rowType.getFieldList().get(i);
                String alias = aliases.size() > i ? (String)aliases.get(i) : null;
                ColumnMetadataImpl fldMeta = new ColumnMetadataImpl(alias != null ? alias : fld.getName(), TypeUtils.columnType(fld.getType()), fld.getType().getPrecision(), fld.getType().getScale(), fld.getType().isNullable(), origins == null ? null : ColumnMetadataImpl.originFromList((List)origins.get(i)));
                fieldsMeta.add(fldMeta);
            }
            return new ResultSetMetadataImpl(fieldsMeta);
        });
    }

    private RelWithMetadata doOptimize(PlanningContext ctx, SqlNode validatedNode, IgnitePlanner planner, @Nullable Runnable onTimeoutAction) {
        IgniteRel igniteRel;
        try {
            igniteRel = PlannerHelper.optimize(validatedNode, planner);
        }
        catch (Exception e) {
            if (ctx.timeouted()) {
                if (onTimeoutAction != null) {
                    onTimeoutAction.run();
                }
                throw new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, "Planning of a query aborted due to planner timeout threshold is reached");
            }
            throw new CompletionException(e);
        }
        RelWithSources reWithSources = Cloner.cloneAndAssignSourceId(igniteRel, Commons.emptyCluster());
        int numTables = reWithSources.sources().size();
        IgniteRel rel = reWithSources.root();
        PartitionPruningMetadata partitionPruningMetadata = new PartitionPruningMetadataExtractor().go(rel);
        PartitionAwarenessMetadata partitionAwarenessMetadata = PartitionAwarenessMetadataExtractor.getMetadata(reWithSources, partitionPruningMetadata);
        return new RelWithMetadata(rel, numTables, partitionAwarenessMetadata, partitionPruningMetadata);
    }

    private static ParameterMetadata createParameterMetadata(RelDataType parameterRowType) {
        if (parameterRowType.getFieldCount() == 0) {
            return EMPTY_PARAMETER_METADATA;
        }
        ArrayList<ParameterType> parameterTypes = new ArrayList<ParameterType>(parameterRowType.getFieldCount());
        for (int i = 0; i < parameterRowType.getFieldCount(); ++i) {
            RelDataTypeField field = (RelDataTypeField)parameterRowType.getFieldList().get(i);
            ParameterType parameterType = TypeUtils.fromRelDataType(field.getType());
            parameterTypes.add(parameterType);
        }
        return new ParameterMetadata(parameterTypes);
    }

    private int directCatalogVersion() {
        return this.schemaManager.catalogVersion(this.currentClock.getAsLong());
    }

    public void statisticsChanged(int tableId) {
        this.planUpdater.statisticsChanged(tableId);
    }

    private static void logPlan(String queryString, ExplainablePlan plan) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plan prepared: \n{}\n\n{}", queryString, plan.explain());
        }
    }

    private static class PlanUpdater {
        private final ScheduledExecutorService planUpdater;
        private final AtomicBoolean inProgress = new AtomicBoolean();
        private volatile boolean recalculatePlans;
        private final Cache<CacheKey, CompletableFuture<PlanInfo>> cache;
        private final long plannerTimeout;
        private final PlanPrepare prepare;
        private final IntSupplier catalogVersionSupplier;
        private final BiFunction<Integer, String, SchemaPlus> defaultSchemaFunc;

        PlanUpdater(ScheduledExecutorService planUpdater, Cache<CacheKey, CompletableFuture<PlanInfo>> cache, long plannerTimeout, PlanPrepare prepare, IntSupplier catalogVersionSupplier, BiFunction<Integer, String, SchemaPlus> defaultSchema) {
            this.planUpdater = planUpdater;
            this.cache = cache;
            this.plannerTimeout = plannerTimeout;
            this.prepare = prepare;
            this.catalogVersionSupplier = catalogVersionSupplier;
            this.defaultSchemaFunc = defaultSchema;
        }

        void statisticsChanged(int tableId) {
            Set<Map.Entry<CacheKey, CompletableFuture<PlanInfo>>> cachedEntries = this.cache.entrySet();
            int currentCatalogVersion = this.catalogVersionSupplier.getAsInt();
            boolean statChanged = false;
            for (Map.Entry<CacheKey, CompletableFuture<PlanInfo>> ent : cachedEntries) {
                CacheKey key = ent.getKey();
                CompletableFuture<PlanInfo> fut = ent.getValue();
                if (currentCatalogVersion != key.catalogVersion() || !CompletableFutures.isCompletedSuccessfully(fut)) continue;
                PlanInfo info = fut.join();
                if (!info.sources.contains(tableId)) continue;
                info.invalidate();
                statChanged = true;
            }
            if (statChanged) {
                this.recalculatePlans = true;
            }
        }

        void start() {
            this.planUpdater.scheduleAtFixedRate(() -> {
                if (!this.recalculatePlans) {
                    return;
                }
                if (!this.inProgress.compareAndSet(false, true)) {
                    return;
                }
                CompletableFuture rePlanningFut = CompletableFutures.nullCompletedFuture();
                while (this.recalculatePlans) {
                    this.recalculatePlans = false;
                    int currentCatalogVersion = this.catalogVersionSupplier.getAsInt();
                    for (Map.Entry<CacheKey, CompletableFuture<PlanInfo>> ent : this.cache.entrySet()) {
                        PlanInfo info;
                        CacheKey key = ent.getKey();
                        CompletableFuture<PlanInfo> fut = this.cache.get(key);
                        if (fut == null || !CompletableFutures.isCompletedSuccessfully(fut) || !(info = fut.join()).needInvalidate()) continue;
                        assert (info.statement != null);
                        if (currentCatalogVersion != key.catalogVersion()) continue;
                        SqlQueryType queryType = info.statement.parsedResult().queryType();
                        SchemaPlus defaultSchema = this.defaultSchemaFunc.apply(key.catalogVersion(), key.schemaName());
                        PlanningContext planningContext = PlanningContext.builder().frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(defaultSchema).build()).query(info.statement.parsedResult().originalQuery()).plannerTimeout(this.plannerTimeout).catalogVersion(key.catalogVersion()).defaultSchemaName(key.schemaName()).parameters(Commons.arrayToMap(key.paramTypes())).build();
                        CompletableFuture<Void> newPlanFut = this.prepare.recalculatePlan(queryType, info.statement.parsedResult, planningContext, key);
                        rePlanningFut.thenCompose(v -> newPlanFut);
                    }
                }
                rePlanningFut.whenComplete((k, err) -> this.inProgress.set(false));
            }, 2000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @FunctionalInterface
    private static interface PlanPrepare {
        public CompletableFuture<Void> recalculatePlan(SqlQueryType var1, ParsedResult var2, PlanningContext var3, CacheKey var4);
    }

    private static class MatchingShuttle
    extends IgniteRelShuttle {
        private final Predicate<QualifiedName> tableNamePredicate;
        private boolean matches;

        private MatchingShuttle(Predicate<QualifiedName> tableNamePredicate) {
            this.tableNamePredicate = tableNamePredicate;
            this.matches = false;
        }

        @Override
        protected IgniteRel processNode(IgniteRel rel) {
            if (!this.matches && rel.getTable() != null) {
                List tableName = rel.getTable().getQualifiedName();
                assert (tableName.size() == 2) : "Qualified table name expected.";
                this.matches = this.tableNamePredicate.test(QualifiedNameHelper.fromNormalized((String)tableName.get(0), (String)tableName.get(1)));
            }
            if (this.matches) {
                return rel;
            }
            List inputs = Commons.cast(rel.getInputs());
            for (int i = 0; i < inputs.size() && !this.matches; ++i) {
                this.visit((IgniteRel)inputs.get(i));
            }
            return rel;
        }

        boolean matches() {
            return this.matches;
        }
    }

    private static class ParsedResultImpl
    implements ParsedResult {
        private final SqlQueryType queryType;
        private final String originalQuery;
        private final String normalizedQuery;
        private final int dynamicParamCount;
        private final SqlNode parsedTree;

        private ParsedResultImpl(SqlQueryType queryType, String originalQuery, String normalizedQuery, int dynamicParamCount, SqlNode parsedTree) {
            this.queryType = queryType;
            this.originalQuery = originalQuery;
            this.normalizedQuery = normalizedQuery;
            this.dynamicParamCount = dynamicParamCount;
            this.parsedTree = parsedTree;
        }

        @Override
        public SqlQueryType queryType() {
            return this.queryType;
        }

        @Override
        public String originalQuery() {
            return this.originalQuery;
        }

        @Override
        public String normalizedQuery() {
            return this.normalizedQuery;
        }

        @Override
        public int dynamicParamsCount() {
            return this.dynamicParamCount;
        }

        @Override
        public SqlNode parsedTree() {
            return this.parsedTree;
        }
    }

    private static class ValidStatement<T> {
        final ParsedResult parsedResult;
        final T value;
        final ParameterMetadata parameterMetadata;

        private ValidStatement(ParsedResult parsedResult, T value, ParameterMetadata parameterMetadata) {
            this.parsedResult = parsedResult;
            this.value = value;
            this.parameterMetadata = parameterMetadata;
        }

        ParsedResult parsedResult() {
            return this.parsedResult;
        }
    }

    private static class RelWithMetadata {
        final IgniteRel rel;
        @Nullable
        final PartitionAwarenessMetadata paMetadata;
        @Nullable
        final PartitionPruningMetadata ppMetadata;
        final int numSources;

        RelWithMetadata(IgniteRel rel, int numSources, @Nullable PartitionAwarenessMetadata paMetadata, @Nullable PartitionPruningMetadata ppMetadata) {
            this.rel = rel;
            this.numSources = numSources;
            this.paMetadata = paMetadata;
            this.ppMetadata = ppMetadata;
        }
    }

    private static class CacheLookupRelVisitor
    extends IgniteRelShuttle {
        boolean caches = false;
        boolean tables = false;

        private CacheLookupRelVisitor() {
        }

        void validate(IgniteRel optimizedRel) {
            this.visit(optimizedRel);
            if (this.tables && this.caches) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Caches and tables can't be mixed in the same query");
            }
        }

        @Override
        public IgniteRel visit(IgniteTableModify rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteIndexScan rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteTableScan rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteTableScanWithAggregate rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteKeyValueModify rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        @Override
        public IgniteRel visit(IgniteKeyValueGet rel) {
            this.lookup(rel.getTable());
            return super.visit(rel);
        }

        private void lookup(RelOptTable relTable) {
            IgniteDataSource dataSource = (IgniteDataSource)relTable.unwrapOrThrow(IgniteDataSource.class);
            if (dataSource instanceof IgniteTable) {
                IgniteTable table = (IgniteTable)dataSource;
                if (table.cache()) {
                    this.caches = true;
                } else {
                    this.tables = true;
                }
            }
        }
    }

    static class PlanInfo {
        private final QueryPlan queryPlan;
        @Nullable
        private final ValidStatement<ValidationResult> statement;
        @Nullable
        private final IntSet sources;
        private volatile boolean needToInvalidate;
        private final Instant timestamp = Instant.now();

        private PlanInfo(QueryPlan plan, @Nullable ValidStatement<ValidationResult> statement, IntSet sources) {
            this.queryPlan = plan;
            this.statement = statement;
            this.sources = sources;
        }

        void invalidate() {
            this.needToInvalidate = true;
        }

        boolean needInvalidate() {
            return this.needToInvalidate;
        }

        static PlanInfo createRefreshable(QueryPlan plan, ValidStatement<ValidationResult> statement, IntSet sources) {
            return new PlanInfo(plan, statement, sources);
        }

        static PlanInfo create(QueryPlan plan) {
            return new PlanInfo(plan, null, IntSet.of());
        }
    }
}

