/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.util.Iterator;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.SortedExternalRowStore;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSortedRowQueue<RowT>
implements RowQueue<RowT>,
AutoCloseable {
    private final RowHandler.RowFactory<RowT> rowFactory;

    AbstractSortedRowQueue(RowHandler.RowFactory<RowT> rowFactory) {
        this.rowFactory = rowFactory;
    }

    abstract SortedExternalRowStore getStore();

    @Override
    public void add(RowT element) {
        this.getStore().add(this.toBinaryTuple(element));
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public void clear() {
        this.getStore().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    @Nullable
    public RowT peek() {
        return this.fromBinaryTuple(this.getStore().peek());
    }

    @Override
    @Nullable
    public RowT poll() {
        return this.fromBinaryTuple(this.getStore().poll());
    }

    @Override
    public RowT remove() {
        return this.fromBinaryTuple(this.getStore().remove());
    }

    @Override
    public Iterator<RowT> iterator() {
        return CollectionUtils.mapIterable(this.getStore(), this::fromBinaryTuple, null).iterator();
    }

    @Override
    public void close() throws Exception {
        this.getStore().close();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private BinaryTuple toBinaryTuple(@Nullable RowT element) {
        return element == null ? null : this.rowFactory.handler().toBinaryTuple(element);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private RowT fromBinaryTuple(@Nullable BinaryTuple oldRow) {
        if (oldRow == null) {
            return null;
        }
        return this.rowFactory.create(oldRow);
    }
}

