/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.IgniteSqlFunctions;

public class GridgainSqlFunctions {
    private GridgainSqlFunctions() {
    }

    @NonDeterministic
    public static long currentTimestampPlusInterval(DataContext ctx, Long interval) {
        return SqlFunctions.currentTimestamp((DataContext)ctx) + interval;
    }

    @NonDeterministic
    public static long currentTimestampWithLocalTimeZonePlusInterval(DataContext ctx, Long interval) {
        long timestamp = (Long)DataContext.Variable.UTC_TIMESTAMP.get(ctx);
        return IgniteSqlFunctions.toTimestampExact(timestamp + interval);
    }

    public static long sequenceNextValue(ExecutionContext<?> ctx, String name, int sequenceId) {
        return ctx.tableRegistry().getSequence(sequenceId).nextVal();
    }

    public static long sequenceCurrentValue(ExecutionContext<?> ctx, String name, int sequenceId) {
        return ctx.tableRegistry().getSequence(sequenceId).currVal();
    }

    public static long sequenceSetValue(ExecutionContext<?> ctx, String name, int sequenceId, long value) {
        return ctx.tableRegistry().getSequence(sequenceId).setVal(value);
    }
}

