/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.exec.SecondaryStoreRowConverterImpl;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite3.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.type.NativeTypes;
import org.jetbrains.annotations.Nullable;

class SecondaryStoreRowConverterFactory
implements TableRowConverterFactory {
    private static final int PARTITION_ID_UNSET_INDEX = -1;
    private final SchemaRegistry schemaRegistry;
    private final TableDescriptor tableDescriptor;
    private final SchemaDescriptor schemaDescriptor;
    private final Int2ObjectArrayMap<IntFunction<VirtualColumn>> virtualColumnsFactory = new Int2ObjectArrayMap();

    SecondaryStoreRowConverterFactory(TableDescriptor tableDescriptor, SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor) {
        this.schemaRegistry = schemaRegistry;
        this.tableDescriptor = tableDescriptor;
        this.schemaDescriptor = schemaDescriptor;
        this.addVirtualColumn(tableDescriptor.columnDescriptor("__PART"));
        this.addVirtualColumn(tableDescriptor.columnDescriptor("__part"));
    }

    @Override
    public TableRowConverter create(int @Nullable [] requiredColumns) {
        if (requiredColumns == null) {
            return this.create(IntStream.range(0, this.schemaDescriptor.length()).toArray(), -1);
        }
        return this.create(requiredColumns, -1);
    }

    @Override
    public TableRowConverter create(int @Nullable [] requiredColumns, int partId) {
        int[] mapping = requiredColumns == null ? IntStream.range(0, this.tableDescriptor.columnsCount()).toArray() : requiredColumns;
        Int2ObjectMap<VirtualColumn> extraColumns = this.createVirtualColumns(mapping, partId);
        return new SecondaryStoreRowConverterImpl(this.schemaRegistry, this.schemaDescriptor, this.tableDescriptor, mapping, extraColumns);
    }

    private void addVirtualColumn(@Nullable ColumnDescriptor columnDescriptor) {
        if (columnDescriptor == null) {
            return;
        }
        assert (columnDescriptor.virtual());
        int columnIndex = columnDescriptor.logicalIndex();
        this.virtualColumnsFactory.put(columnIndex, partId -> new VirtualColumn(columnIndex, NativeTypes.INT32, false, partId));
    }

    private Int2ObjectMap<VirtualColumn> createVirtualColumns(int[] requiredColumns, int partId) {
        if (this.virtualColumnsFactory.isEmpty()) {
            return Int2ObjectMaps.emptyMap();
        }
        Int2ObjectArrayMap columnsMap = new Int2ObjectArrayMap(this.virtualColumnsFactory.size());
        for (int i : requiredColumns) {
            if (i < this.schemaDescriptor.length()) continue;
            columnsMap.put(i, (Object)((VirtualColumn)((IntFunction)this.virtualColumnsFactory.get(i)).apply(partId)));
        }
        return columnsMap;
    }
}

