/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rocksdb;

import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.CompactionJobInfo;
import org.rocksdb.FlushJobInfo;
import org.rocksdb.RocksDB;

public class LoggingRocksDbFlushListener
extends AbstractEventListener {
    private static final IgniteLogger LOG = Loggers.forClass(LoggingRocksDbFlushListener.class);
    private final String name;
    private final String nodeName;
    private final AtomicReference<AbstractEventListener.EnabledEventCallback> lastFlushEventType = new AtomicReference<AbstractEventListener.EnabledEventCallback>(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED);
    private final AtomicReference<AbstractEventListener.EnabledEventCallback> lastCompactionEventType = new AtomicReference<AbstractEventListener.EnabledEventCallback>(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED);
    private volatile long lastFlushStartTimeNanos;
    private volatile long lastCompactionStartTimeNanos;

    public LoggingRocksDbFlushListener(String name, String nodeName) {
        super(AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED);
        this.name = name;
        this.nodeName = nodeName;
    }

    @Override
    public void onFlushBegin(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastFlushEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting rocksdb flush process [name='{}', nodeName='{}', reason={}]", new Object[]{this.name, this.nodeName, flushJobInfo.getFlushReason()});
                this.lastFlushStartTimeNanos = System.nanoTime();
            }
            this.onFlushBeginCallback(db, flushJobInfo);
        }
    }

    @Override
    public void onFlushCompleted(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastFlushEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED)) {
            if (LOG.isInfoEnabled()) {
                long duration = System.nanoTime() - this.lastFlushStartTimeNanos;
                LOG.info("Finishing rocksdb flush process [name='{}', nodeName='{}', duration={}ms]", this.name, this.nodeName, TimeUnit.NANOSECONDS.toMillis(duration));
            }
            this.onFlushCompletedCallback(db, flushJobInfo);
        }
    }

    protected void onFlushBeginCallback(RocksDB db, FlushJobInfo flushJobInfo) {
    }

    protected void onFlushCompletedCallback(RocksDB db, FlushJobInfo flushJobInfo) {
    }

    @Override
    public void onCompactionBegin(RocksDB db, CompactionJobInfo compactionJobInfo) {
        if (this.lastCompactionEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN) && LOG.isInfoEnabled()) {
            LOG.info("Starting rocksdb compaction process [name='{}', nodeName='{}', reason={}, input={}, output={}]", new Object[]{this.name, this.nodeName, compactionJobInfo.compactionReason(), compactionJobInfo.inputFiles().stream().map(path -> Paths.get(path, new String[0]).getFileName()).collect(Collectors.toList()), compactionJobInfo.outputFiles().stream().map(path -> Paths.get(path, new String[0]).getFileName()).collect(Collectors.toList())});
            this.lastCompactionStartTimeNanos = System.nanoTime();
        }
    }

    @Override
    public void onCompactionCompleted(RocksDB db, CompactionJobInfo compactionJobInfo) {
        if (this.lastCompactionEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED) && LOG.isInfoEnabled()) {
            long duration = System.nanoTime() - this.lastCompactionStartTimeNanos;
            LOG.info("Finishing rocksdb compaction process [name='{}', nodeName='{}', duration={}ms]", this.name, this.nodeName, TimeUnit.NANOSECONDS.toMillis(duration));
        }
    }
}

