/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.configuration.validation.ConfigurationValidationException;
import org.apache.ignite3.internal.cluster.management.ClusterInitializer;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.cluster.ClusterManagementApi;
import org.apache.ignite3.internal.rest.api.cluster.ClusterTag;
import org.apache.ignite3.internal.rest.api.cluster.InitCommand;
import org.apache.ignite3.internal.rest.cluster.exception.InvalidArgumentClusterInitializationException;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/cluster")
public class ClusterManagementController
implements ClusterManagementApi,
ResourceHolder {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementController.class);
    private ClusterInitializer clusterInitializer;
    private ClusterManagementGroupManager clusterManagementGroupManager;
    private ObjectMapper jsonMapper;

    public ClusterManagementController(ClusterInitializer clusterInitializer, ClusterManagementGroupManager clusterManagementGroupManager) {
        this.clusterInitializer = clusterInitializer;
        this.clusterManagementGroupManager = clusterManagementGroupManager;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public CompletableFuture<org.apache.ignite3.internal.rest.api.cluster.ClusterState> clusterState() {
        return ((CompletableFuture)this.clusterManagementGroupManager.clusterState().thenApply(ClusterManagementController::mapClusterState)).exceptionally(ex -> {
            throw ClusterManagementController.mapException(ex);
        });
    }

    @Override
    public CompletableFuture<Void> init(@Body InitCommand initCommand) {
        LOG.info("Received init command [metaStorageNodes={}, cmgNodes={}]", initCommand.metaStorageNodes(), initCommand.cmgNodes());
        return this.clusterInitializer.initCluster(initCommand.metaStorageNodes(), initCommand.cmgNodes(), initCommand.clusterName(), initCommand.clusterConfiguration(), initCommand.license()).exceptionally(ex -> {
            throw ClusterManagementController.mapException(ex);
        });
    }

    private static org.apache.ignite3.internal.rest.api.cluster.ClusterState mapClusterState(@Nullable ClusterState clusterState) {
        if (clusterState == null) {
            throw new IgniteException(ErrorGroups.Rest.CLUSTER_NOT_INIT_ERR, "Cluster has not yet been initialized or the node is in the process of being stopped.");
        }
        return new org.apache.ignite3.internal.rest.api.cluster.ClusterState(clusterState.cmgNodes(), clusterState.metaStorageNodes(), clusterState.igniteVersion().toString(), new ClusterTag(clusterState.clusterTag().clusterName(), clusterState.clusterTag().clusterId()), clusterState.formerClusterIds());
    }

    private static RuntimeException mapException(Throwable ex) {
        Throwable cause = ExceptionUtils.unwrapCause(ex);
        if (cause instanceof IgniteInternalException) {
            return (IgniteInternalException)cause;
        }
        if (cause instanceof IllegalArgumentException || cause instanceof ConfigurationValidationException) {
            return new InvalidArgumentClusterInitializationException(cause);
        }
        if (cause instanceof IgniteException) {
            return (RuntimeException)cause;
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, cause);
    }

    @Override
    public void cleanResources() {
        this.clusterInitializer = null;
        this.clusterManagementGroupManager = null;
        this.jsonMapper = null;
    }
}

