/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.raft.util.VarlenEncoder;
import org.apache.ignite3.internal.util.FastCrc;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;

class SegmentPayload {
    static final int GROUP_ID_SIZE_BYTES = 8;
    static final int LENGTH_SIZE_BYTES = 4;
    static final int HASH_SIZE = 4;
    static final int TRUNCATE_SUFFIX_RECORD_SIZE = 24;
    private static final int TRUNCATE_SUFFIX_RECORD_MARKER = 0;

    SegmentPayload() {
    }

    static void writeTo(ByteBuffer buffer, long groupId, int segmentEntrySize, LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        int originalPos = buffer.position();
        buffer.putLong(groupId).putInt(segmentEntrySize - SegmentPayload.fixedOverheadSize());
        LogId logId = logEntry.getId();
        VarlenEncoder.writeLong(logId.getIndex(), buffer);
        VarlenEncoder.writeLong(logId.getTerm(), buffer);
        logEntryEncoder.encode(buffer, logEntry);
        int dataSize = buffer.position() - originalPos;
        buffer.position(originalPos);
        int crc = FastCrc.calcCrc(buffer, dataSize);
        buffer.putInt(crc);
    }

    static void writeTruncateSuffixRecordTo(ByteBuffer buffer, long groupId, long lastLogIndexKept) {
        int originalPos = buffer.position();
        buffer.putLong(groupId).putInt(0).putLong(lastLogIndexKept);
        buffer.position(originalPos);
        int crc = FastCrc.calcCrc(buffer, 20);
        buffer.putInt(crc);
    }

    static LogEntry readFrom(ByteBuffer buffer, LogEntryDecoder logEntryDecoder) {
        int originalPosition = buffer.position();
        buffer.position(originalPosition + 8);
        int payloadLength = buffer.getInt();
        int payloadPosition = buffer.position();
        VarlenEncoder.readLong(buffer);
        VarlenEncoder.readLong(buffer);
        int logEntryPosition = buffer.position();
        int crcPosition = payloadPosition + payloadLength;
        int crc = buffer.getInt(crcPosition);
        buffer.position(originalPosition);
        int actualCrc = FastCrc.calcCrc(buffer, crcPosition - originalPosition);
        if (crc != actualCrc) {
            throw new IllegalStateException("CRC mismatch, expected: " + crc + ", actual: " + actualCrc);
        }
        buffer.position(logEntryPosition);
        byte[] entryBytes = new byte[crcPosition - logEntryPosition];
        buffer.get(entryBytes);
        buffer.position(buffer.position() + 4);
        return logEntryDecoder.decode(entryBytes);
    }

    static int size(LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        int entrySize = logEntryEncoder.size(logEntry);
        LogId logId = logEntry.getId();
        return SegmentPayload.fixedOverheadSize() + VarlenEncoder.sizeInBytes(logId.getIndex()) + VarlenEncoder.sizeInBytes(logId.getTerm()) + entrySize;
    }

    static int fixedOverheadSize() {
        return 16;
    }
}

