/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.TransferRowVersionsToSecondaryReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.TransferRowVersionsToSecondaryReplicaRequestBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class TransferRowVersionsToSecondaryReplicaRequestDeserializer
implements MessageDeserializer<TransferRowVersionsToSecondaryReplicaRequest> {
    private final TransferRowVersionsToSecondaryReplicaRequestBuilder msg;

    TransferRowVersionsToSecondaryReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.transferRowVersionsToSecondaryReplicaRequest();
    }

    @Override
    public Class<TransferRowVersionsToSecondaryReplicaRequest> klass() {
        return TransferRowVersionsToSecondaryReplicaRequest.class;
    }

    @Override
    public TransferRowVersionsToSecondaryReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.transferRowVersionsToSecondaryReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("rows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rows((List<BinaryRowWithTombstoneMessage>)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 4: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TransferRowVersionsToSecondaryReplicaRequest.class);
    }
}

