/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor.wasm;

import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.wasi.WasiOptions;
import com.dylibso.chicory.wasi.WasiPreview1;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValType;
import java.io.OutputStream;
import java.util.List;

class GoWasiUtils {
    private static final WasiPreview1 wasiPreview1 = WasiPreview1.builder().withOptions(WasiOptions.builder().withStdout((OutputStream)System.out).withStderr((OutputStream)System.err).build()).build();
    private static final long[] WASI_ESUCCESS = new long[]{0L};
    private static final long[] WASI_EINVAL = new long[]{28L};
    static HostFunction[] MINIMAL_GO_WASI_FUNCS = GoWasiUtils.getMinimalGoFuncs();

    GoWasiUtils() {
    }

    private static HostFunction[] getMinimalGoFuncs() {
        String moduleName = "wasi_snapshot_preview1";
        WasiPreview1 functions = wasiPreview1;
        assert (functions != null);
        return new HostFunction[]{new HostFunction(moduleName, "args_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> WASI_ESUCCESS), new HostFunction(moduleName, "args_sizes_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> WASI_ESUCCESS), new HostFunction(moduleName, "clock_res_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.clockResGet(instance.memory(), (int)args[0], (int)args[1]);
            return new long[]{result};
        }), new HostFunction(moduleName, "clock_time_get", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.clockTimeGet(instance.memory(), (int)args[0], args[1], (int)args[2]);
            return new long[]{result};
        }), new HostFunction(moduleName, "environ_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("environ_get");
        }), new HostFunction(moduleName, "environ_sizes_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> WASI_ESUCCESS), new HostFunction(moduleName, "fd_advise", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_advise");
        }), new HostFunction(moduleName, "fd_allocate", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I64), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_allocate");
        }), new HostFunction(moduleName, "fd_close", FunctionType.of(List.of(ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_close");
        }), new HostFunction(moduleName, "fd_datasync", FunctionType.of(List.of(ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_datasync");
        }), new HostFunction(moduleName, "fd_fdstat_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> WASI_ESUCCESS), new HostFunction(moduleName, "fd_fdstat_set_flags", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> WASI_EINVAL), new HostFunction(moduleName, "fd_fdstat_set_rights", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I64), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_fdstat_set_rights");
        }), new HostFunction(moduleName, "fd_filestat_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_filestat_get");
        }), new HostFunction(moduleName, "fd_filestat_set_size", FunctionType.of(List.of(ValType.I32, ValType.I64), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_filestat_set_size");
        }), new HostFunction(moduleName, "fd_filestat_set_times", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_filestat_set_times");
        }), new HostFunction(moduleName, "fd_pread", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_pread");
        }), new HostFunction(moduleName, "fd_prestat_dir_name", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.fdPrestatDirName(instance.memory(), (int)args[0], (int)args[1], (int)args[2]);
            return new long[]{result};
        }), new HostFunction(moduleName, "fd_prestat_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.fdPrestatGet(instance.memory(), (int)args[0], (int)args[1]);
            return new long[]{result};
        }), new HostFunction(moduleName, "fd_pwrite", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_pwrite");
        }), new HostFunction(moduleName, "fd_read", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_read");
        }), new HostFunction(moduleName, "fd_readdir", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_readdir");
        }), new HostFunction(moduleName, "fd_renumber", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_renumber");
        }), new HostFunction(moduleName, "fd_seek", FunctionType.of(List.of(ValType.I32, ValType.I64, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_seek");
        }), new HostFunction(moduleName, "fd_sync", FunctionType.of(List.of(ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_sync");
        }), new HostFunction(moduleName, "fd_tell", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("fd_tell");
        }), new HostFunction(moduleName, "fd_write", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.fdWrite(instance.memory(), (int)args[0], (int)args[1], (int)args[2], (int)args[3]);
            return new long[]{result};
        }), new HostFunction(moduleName, "path_create_directory", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_create_directory");
        }), new HostFunction(moduleName, "path_filestat_get", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_filestat_get");
        }), new HostFunction(moduleName, "path_filestat_set_times", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I64, ValType.I64, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_filestat_set_times");
        }), new HostFunction(moduleName, "path_link", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_link");
        }), new HostFunction(moduleName, "path_open", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I64, ValType.I64, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_open");
        }), new HostFunction(moduleName, "path_readlink", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_readlink");
        }), new HostFunction(moduleName, "path_remove_directory", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_remove_directory");
        }), new HostFunction(moduleName, "path_rename", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_rename");
        }), new HostFunction(moduleName, "path_symlink", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_symlink");
        }), new HostFunction(moduleName, "path_unlink_file", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("path_unlink_file");
        }), new HostFunction(moduleName, "poll_oneoff", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.pollOneoff(instance.memory(), (int)args[0], (int)args[1], (int)args[2], (int)args[3]);
            return new long[]{result};
        }), new HostFunction(moduleName, "proc_exit", FunctionType.of(List.of(ValType.I32), List.of()), (instance, args) -> {
            throw GoWasiUtils.notAllowed("proc_exit");
        }), new HostFunction(moduleName, "proc_raise", FunctionType.of(List.of(ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("proc_raise");
        }), new HostFunction(moduleName, "random_get", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            int result = functions.randomGet(instance.memory(), (int)args[0], (int)args[1]);
            return new long[]{result};
        }), new HostFunction(moduleName, "sched_yield", FunctionType.of(List.of(), List.of(ValType.I32)), (instance, args) -> WASI_ESUCCESS), new HostFunction(moduleName, "sock_accept", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("sock_accept");
        }), new HostFunction(moduleName, "sock_recv", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("sock_recv");
        }), new HostFunction(moduleName, "sock_send", FunctionType.of(List.of(ValType.I32, ValType.I32, ValType.I32, ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("sock_send");
        }), new HostFunction(moduleName, "sock_shutdown", FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32)), (instance, args) -> {
            throw GoWasiUtils.notAllowed("sock_shutdown");
        })};
    }

    private static UnsupportedOperationException notAllowed(String name) {
        return new UnsupportedOperationException("WASI call is not allowed: " + name);
    }
}

