/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.ignite3.cache.Cache;
import org.apache.ignite3.cache.manager.IgniteCaches;
import org.apache.ignite3.internal.compute.executor.SecuredTableViewInternal;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.Table;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredIgniteTables
implements IgniteTables,
IgniteCaches {
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private static final Privilege READ_SCHEMA_PRIVILEGE = Privilege.builder().action(Action.READ_SCHEMA).selector(Selector.schema("PUBLIC")).build();
    private final IgniteTables tables;
    private final IgniteCaches caches;
    private final Authorizer authorizer;
    private final SecurityContext securityContext;

    SecuredIgniteTables(IgniteTables tables, IgniteCaches caches, Authorizer authorizer, SecurityContext securityContext) {
        this.tables = tables;
        this.caches = caches;
        this.authorizer = authorizer;
        this.securityContext = securityContext;
    }

    @Override
    public List<Table> tables() {
        return SecuredIgniteTables.join(this.tablesAsync());
    }

    @Override
    public List<Cache> caches() {
        return SecuredIgniteTables.join(this.cachesAsync());
    }

    @Override
    public CompletableFuture<List<Table>> tablesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, this.tables::tablesAsync).thenApply(tables -> tables.stream().map(this::wrapTable).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, this.caches::cachesAsync).thenApply(tables -> tables.stream().map(this::wrapCache).collect(Collectors.toList()));
    }

    @Override
    public Table table(String name) {
        return SecuredIgniteTables.join(this.tableAsync(name));
    }

    @Override
    public Table table(QualifiedName name) {
        return SecuredIgniteTables.join(this.tableAsync(name));
    }

    @Override
    public Cache cache(String name) {
        return SecuredIgniteTables.join(this.cacheAsync(name));
    }

    @Override
    @Nullable
    public Cache cache(QualifiedName name) {
        return SecuredIgniteTables.join(this.cacheAsync(name));
    }

    @Override
    public CompletableFuture<Table> tableAsync(String name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.tables.tableAsync(name)).thenApply(this::wrapTable);
    }

    @Override
    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.tables.tableAsync(name)).thenApply(this::wrapTable);
    }

    @Override
    public CompletableFuture<Cache> cacheAsync(String name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.caches.cacheAsync(name)).thenApply(this::wrapCache);
    }

    @Override
    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.caches.cacheAsync(name)).thenApply(this::wrapCache);
    }

    private SecuredTableViewInternal wrapTable(Table table) {
        return new SecuredTableViewInternal(Wrappers.unwrap(table, TableViewInternal.class), this.authorizer, this.securityContext);
    }

    private SecuredTableViewInternal wrapCache(Cache table) {
        return new SecuredTableViewInternal(Wrappers.unwrap(table, TableViewInternal.class), this.authorizer, this.securityContext);
    }

    private static <T> T join(CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException ex) {
            throw SecuredIgniteTables.convertThrowable(ex.getCause());
        }
    }

    private static RuntimeException convertThrowable(Throwable th) {
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, th);
    }
}

