/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.tx;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.ignite3.internal.client.ClientChannel;
import org.apache.ignite3.internal.client.PartitionMapping;
import org.apache.ignite3.internal.client.PayloadInputChannel;
import org.apache.ignite3.internal.client.PayloadOutputChannel;
import org.apache.ignite3.internal.client.ReliableChannel;
import org.apache.ignite3.internal.client.WriteContext;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite3.internal.client.tx.ClientTransaction;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class DirectTxUtils {
    public static CompletableFuture<@Nullable ClientTransaction> ensureStarted(ReliableChannel ch, @Nullable Transaction tx, @Nullable PartitionMapping pm, WriteContext ctx, Predicate<ClientChannel> piggybackSupported) {
        if (tx == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (pm == null) {
            CompletableFuture<ClientTransaction> transactionFuture = ClientLazyTransaction.ensureStarted(tx, ch, () -> ch.getChannelAsync(null)).get1();
            assert (transactionFuture != null);
            return transactionFuture;
        }
        return ch.getChannelAsync(pm.nodeConsistentId()).thenCompose(ch0 -> {
            IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> tuple = ClientLazyTransaction.ensureStarted(tx, ch, piggybackSupported.test((ClientChannel)ch0) ? null : () -> CompletableFuture.completedFuture(ch0));
            ClientLazyTransaction tx0 = (ClientLazyTransaction)tx;
            if (tuple.get2().booleanValue()) {
                ctx.pm = pm;
                ctx.readOnly = tx0.isReadOnly();
                ctx.external = tx0.isExternal();
                ctx.channel = ch0;
                ctx.firstReqFut = tuple.get1();
                return CompletableFutures.nullCompletedFuture();
            }
            return tuple.get1();
        });
    }

    public static void writeTx(@Nullable Transaction tx, PayloadOutputChannel out, @Nullable WriteContext ctx) {
        if (tx == null) {
            out.out().packNil();
        } else if (ctx != null && (ctx.enlistmentToken != null || ctx.firstReqFut != null)) {
            if (ctx.firstReqFut != null) {
                ClientLazyTransaction tx0 = (ClientLazyTransaction)tx;
                out.out().packLong(-1L);
                out.out().packLong(tx0.observableTimestamp());
                out.out().packBoolean(tx.isReadOnly());
                out.out().packLong(tx0.timeout());
                out.out().packBoolean(tx0.isExternal());
            } else {
                ClientTransaction tx0 = ClientTransaction.get(tx);
                out.out().packLong(0L);
                out.out().packLong(ctx.enlistmentToken);
                out.out().packUuid(tx0.txId());
                out.out().packInt(tx0.commitTableId());
                out.out().packInt(tx0.commitPartition());
                out.out().packUuid(tx0.coordinatorId());
                out.out().packLong(tx0.timeout());
                out.out().packBoolean(tx0.external());
            }
        } else {
            ClientTransaction tx0 = ClientTransaction.get(tx);
            if (tx0.channel() != out.clientChannel()) {
                throw new IgniteException(ErrorGroups.Client.CONNECTION_ERR, "Transaction context has been lost due to connection errors.");
            }
            out.out().packLong(tx0.id());
        }
    }

    public static void readTx(PayloadInputChannel payloadChannel, WriteContext ctx, @Nullable ClientTransaction tx, HybridTimestampTracker observableTimestamp) {
        ClientMessageUnpacker in = payloadChannel.in();
        if (ctx.firstReqFut != null) {
            assert (tx == null);
            long id = in.unpackLong();
            UUID txId = in.unpackUuid();
            UUID coordId = in.unpackUuid();
            long timeout = in.unpackLong();
            ClientTransaction startedTx = new ClientTransaction(payloadChannel.clientChannel(), id, ctx.readOnly, ctx.external, txId, ctx.pm, coordId, observableTimestamp, timeout);
            ctx.firstReqFut.complete(startedTx);
        } else if (ctx.enlistmentToken != null) {
            assert (tx != null);
            assert (ctx.pm != null);
            if (in.tryUnpackNil()) {
                payloadChannel.clientChannel().inflights().removeInflight(tx.txId(), null);
                if (ctx.enlistmentToken == 0L) {
                    tx.tryFailEnlist(ctx.pm, new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Encountered no-op on first direct enlistment, server version upgrade is required"));
                }
            } else {
                String consistentId = payloadChannel.in().unpackString();
                long token = payloadChannel.in().unpackLong();
                if (payloadChannel.in().unpackBoolean()) {
                    payloadChannel.clientChannel().inflights().removeInflight(tx.txId(), null);
                }
                if (ctx.enlistmentToken == 0L) {
                    tx.tryFinishEnlist(ctx.pm, consistentId, token);
                }
            }
        }
    }

    public static CompletableFuture<ClientChannel> resolveChannel(WriteContext ctx, ReliableChannel ch, boolean trackOperation, @Nullable ClientTransaction tx, @Nullable PartitionMapping mapping) {
        CompletableFuture<ClientChannel> chFuture = ctx.firstReqFut != null ? CompletableFuture.completedFuture(ctx.channel) : ch.getChannelAsync(DirectTxUtils.resolvePreferredNode(tx, mapping));
        return chFuture.thenCompose(opCh -> {
            if (tx != null && tx.hasCommitPartition() && !tx.nodeName().equals(opCh.protocolContext().clusterNode().name())) {
                ctx.pm = mapping;
                return DirectTxUtils.enlistDirect(tx, ch, opCh, ctx, trackOperation).thenApply(ignored -> opCh);
            }
            return CompletableFuture.completedFuture(opCh);
        });
    }

    @Nullable
    private static String resolvePreferredNode(@Nullable ClientTransaction tx, @Nullable PartitionMapping pm) {
        String opNode;
        String string = opNode = pm == null ? null : pm.nodeConsistentId();
        if (tx != null) {
            return !tx.isReadOnly() && tx.hasCommitPartition() && opNode != null ? opNode : tx.nodeName();
        }
        return opNode;
    }

    private static CompletableFuture<Void> enlistDirect(ClientTransaction tx, ReliableChannel ch, ClientChannel opChannel, WriteContext ctx, boolean trackOperation) {
        return tx.enlistFuture(ch, opChannel, ctx.pm, trackOperation).thenCompose(tup -> {
            if (tup.get2() == null) {
                ctx.enlistmentToken = 0L;
                return CompletableFutures.nullCompletedFuture();
            }
            if ((Long)tup.get2() == 0L) {
                return DirectTxUtils.enlistDirect(tx, ch, opChannel, ctx, trackOperation);
            }
            ctx.enlistmentToken = (Long)tup.get2();
            return CompletableFutures.nullCompletedFuture();
        });
    }
}

