/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.exception.handler;

import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.handler.IgniteCliApiExceptionHandler;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Problem;

public class ClusterNotInitializedExceptionHandler
extends IgniteCliApiExceptionHandler {
    private final String header;
    private final String command;

    public ClusterNotInitializedExceptionHandler(String header, String command) {
        super(header);
        this.header = header;
        this.command = command;
    }

    @Override
    public int handle(ExceptionWriter err, IgniteCliApiException e) {
        ApiException apiException;
        if (e.getCause() instanceof ApiException && (apiException = (ApiException)e.getCause()).getCode() == 409) {
            ErrorUiComponent.ErrorComponentBuilder builder = ErrorUiComponent.builder().header(this.header, new UiElement[0]).verbose(apiException.getMessage(), new UiElement[0]);
            this.fillDetails(builder, apiException);
            err.write(builder.build().render());
            return 1;
        }
        return super.handle(err, e);
    }

    private void fillDetails(ErrorUiComponent.ErrorComponentBuilder builder, ApiException apiException) {
        Problem problem;
        if (apiException.getResponseBody() != null && (problem = ClusterNotInitializedExceptionHandler.extractProblem(apiException.getResponseBody())).getCode() != null) {
            builder.details(problem.getDetail(), new UiElement[0]);
            return;
        }
        builder.details("Probably, you have not initialized the cluster, try to run %s command", UiElements.command(this.command));
    }

    public static ClusterNotInitializedExceptionHandler createHandler(String message) {
        return new ClusterNotInitializedExceptionHandler(message, "ignite cluster init");
    }

    public static ClusterNotInitializedExceptionHandler createReplHandler(String message) {
        return new ClusterNotInitializedExceptionHandler(message, "cluster init");
    }

    public static boolean isClusterNotInitialized(ApiException apiException) {
        return apiException.getCode() == 409 && apiException.getResponseBody() != null && apiException.getResponseBody().contains("Cluster is not initialized");
    }
}

