/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.jetbrains.annotations.Nullable;

public class CatalogSerializationUtils {
    @Nullable
    public static String readNullableString(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static void writeNullableString(@Nullable String str, DataOutput out) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }

    @Nullable
    public static Integer readNullableInteger(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readInt();
    }

    public static void writeNullableInteger(@Nullable Integer value, DataOutput out) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            out.writeInt(value);
        }
    }

    public static <T> List<T> readList(CatalogObjectSerializer<T> serializer, CatalogObjectDataInput input) throws IOException {
        int len = input.readVarIntAsInt();
        ArrayList<T> entries = new ArrayList<T>(len);
        for (int i = 0; i < len; ++i) {
            T item = serializer.readFrom(input);
            entries.add(item);
        }
        return entries;
    }

    @Nullable
    public static Long readNullableLong(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readLong();
    }

    @Nullable
    public static Double readNullableDouble(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readDouble();
    }

    public static void writeNullableLong(@Nullable Long value, DataOutput out) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            out.writeLong(value);
        }
    }

    public static void writeNullableDouble(@Nullable Double value, DataOutput out) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            out.writeDouble(value);
        }
    }

    public static <T> void writeList(List<T> items, CatalogObjectSerializer<T> serializer, CatalogObjectDataOutput output) throws IOException {
        output.writeVarInt(items.size());
        for (T item : items) {
            serializer.writeTo(item, output);
        }
    }

    @Deprecated
    public static class IndexDescriptorSerializerHelper
    implements CatalogObjectSerializer<CatalogIndexDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public IndexDescriptorSerializerHelper(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            byte idxType = input.readByte();
            CatalogIndexDescriptor.CatalogIndexDescriptorType type = CatalogIndexDescriptor.CatalogIndexDescriptorType.forId(idxType);
            if (type == CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH) {
                return (CatalogIndexDescriptor)this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_HASH_INDEX.id()).readFrom(input);
            }
            return (CatalogIndexDescriptor)this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SORTED_INDEX.id()).readFrom(input);
        }

        @Override
        public void writeTo(CatalogIndexDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeByte(descriptor.indexType().id());
            this.serializers.get(1, descriptor.typeId()).writeTo(descriptor, output);
        }
    }
}

