/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.util.ArrayUtils;

public class NewMapEntry
implements UpdateEntry,
Fireable {
    private final CatalogMapDescriptor descriptor;

    public NewMapEntry(CatalogMapDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogMapDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_MAP.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.MAP_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CatalogEventParameters(causalityToken, catalogVersion){};
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.descriptor.schemaId());
        this.descriptor.updateTimestamp(timestamp);
        List<CatalogSchemaDescriptor> schemas = CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), schema.sequences(), schema.policies(), ArrayUtils.concat(schema.maps(), this.descriptor), timestamp), catalog.schemas());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

