/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class CatalogSequenceDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class SequenceDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSequenceDescriptor> {
        SequenceDescriptorSerializerV2() {
        }

        @Override
        public CatalogSequenceDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(updateTimestampLong);
            int id = input.readVarIntAsInt();
            int tableId = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            int version = input.readVarIntAsInt();
            String name = input.readUTF();
            long increment = input.readVarInt();
            long minvalue = input.readVarInt();
            long maxvalue = input.readVarInt();
            long start = input.readVarInt();
            long cache = input.readVarInt();
            return new CatalogSequenceDescriptor(updateTimestamp, id, tableId, schemaId, version, name, increment, minvalue, maxvalue, start, cache);
        }

        @Override
        public void writeTo(CatalogSequenceDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.id());
            output.writeVarInt(descriptor.tableId());
            output.writeVarInt(descriptor.schemaId());
            output.writeVarInt(descriptor.version());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.increment());
            output.writeVarInt(descriptor.minvalue());
            output.writeVarInt(descriptor.maxvalue());
            output.writeVarInt(descriptor.start());
            output.writeVarInt(descriptor.cachevalue());
        }
    }
}

