/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetPropertyCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterTablePropertiesEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.jetbrains.annotations.Nullable;

public class AlterTableSetPropertyCommand
extends AbstractTableCommand {
    @Nullable
    private final Double staleRowsFraction;
    @Nullable
    private final Long minStaleRowsCount;

    public static AlterTableSetPropertyCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableSetPropertyCommand(String tableName, String schemaName, boolean ifTableExists, @Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
        this.staleRowsFraction = staleRowsFraction;
        this.minStaleRowsCount = minStaleRowsCount;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        if (this.staleRowsFraction == null && this.minStaleRowsCount == null) {
            return List.of();
        }
        return List.of(new AlterTablePropertiesEntry(table.id(), this.staleRowsFraction, this.minStaleRowsCount));
    }

    private void validate() {
        if (this.staleRowsFraction != null && (!Double.isFinite(this.staleRowsFraction) || this.staleRowsFraction > 1.0 || this.staleRowsFraction < 0.0)) {
            throw new CatalogValidationException("Stale rows fraction should be in range [0, 1].");
        }
        if (this.minStaleRowsCount != null && this.minStaleRowsCount < 0L) {
            throw new CatalogValidationException("Minimal stale rows count should be non-negative.");
        }
    }

    private static class Builder
    implements AlterTableSetPropertyCommandBuilder {
        @Nullable
        private Double staleRowsFraction;
        @Nullable
        private Long minStaleRowsCount;
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableSetPropertyCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableSetPropertyCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableSetPropertyCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableSetPropertyCommandBuilder staleRowsFraction(double staleRowsFraction) {
            this.staleRowsFraction = staleRowsFraction;
            return this;
        }

        @Override
        public AlterTableSetPropertyCommandBuilder minStaleRowsCount(long minStaleRowsCount) {
            this.minStaleRowsCount = minStaleRowsCount;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableSetPropertyCommand(this.tableName, this.schemaName, this.ifTableExists, this.staleRowsFraction, this.minStaleRowsCount);
        }
    }
}

