/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlExecuteRequest;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.CancelHandle;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientSqlExecuteScriptRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, QueryProcessor sql, long requestId, Map<Long, CancelHandle> cancelHandleMap, HybridTimestampTracker tsTracker, String username) {
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandleMap.put(requestId, cancelHandle);
        SecurityContext context = SecurityContextHolder.getOrThrow();
        ClientSqlProperties props = new ClientSqlProperties(in);
        String script = in.unpackString();
        Object[] arguments = ClientSqlExecuteRequest.readArgsNotNull(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp(in.unpackLong());
        tsTracker.update(clientTs);
        return CompletableFutures.nullCompletedFuture().thenComposeAsync(none -> IgniteSqlImpl.executeScriptCore(sql, tsTracker, () -> true, () -> {}, script, cancelHandle.token(), arguments, props.toSqlProps().userName(username), operationExecutor, context).handle((none2, error) -> {
            cancelHandleMap.remove(requestId);
            if (error != null) {
                ExceptionUtils.sneakyThrow(error);
            }
            return null;
        }), operationExecutor);
    }
}

