/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.iceberg;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.SdkSystemSetting;

public final class IcebergUtils {
    private IcebergUtils() {
    }

    public static Map<String, String> combineProperties(CopyLocationPath location, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties);
        result.computeIfAbsent("warehouse", k -> location.path());
        result.computeIfAbsent("client.region", k -> (String)properties.get("s3.client-region"));
        return result;
    }

    public static Configuration combineConfiguration(Map<String, String> properties) {
        Configuration conf = new Configuration();
        IcebergUtils.trySetAwsProperties(conf, properties, "s3.access-key-id", "s3.secret-access-key", "s3.session-token", "s3.client-region", "s3.endpoint");
        IcebergUtils.trySetAwsProperties(conf, properties, "fs.s3a.access.key", "fs.s3a.secret.key", "fs.s3a.session.token", "fs.s3a.endpoint.region", "fs.s3a.endpoint");
        IcebergUtils.trySetAwsProperties(conf, properties, SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), SdkSystemSetting.AWS_SESSION_TOKEN.property(), SdkSystemSetting.AWS_REGION.property(), null);
        return conf;
    }

    private static void trySetAwsProperties(Configuration conf, Map<String, String> properties, @Nullable String keyAccessKey, @Nullable String keySecretKey, @Nullable String keySessionToken, @Nullable String keyRegion, @Nullable String endpoint) {
        Optional.ofNullable(properties.get(keyAccessKey)).ifPresent(v -> {
            conf.set("fs.s3a.access.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.accessKeyId"), System.getenv("AWS_ACCESS_KEY_ID"), System.getenv("AWS_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keySecretKey)).ifPresent(v -> {
            conf.set("fs.s3a.secret.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.secretKey"), System.getenv("AWS_SECRET_KEY"), System.getenv("AWS_SECRET_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keySessionToken)).ifPresent(v -> {
            conf.set("fs.s3a.session.token", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.sessionToken"), System.getenv("AWS_SESSION_TOKEN")})) {
                System.setProperty(SdkSystemSetting.AWS_SESSION_TOKEN.property(), v);
            }
        });
        Optional.ofNullable(properties.get(keyRegion)).ifPresent(v -> conf.set("fs.s3a.endpoint.region", v));
        Optional.ofNullable(properties.get(endpoint)).ifPresent(v -> conf.set("fs.s3a.endpoint", v));
    }

    public static List<Object> asList(Record rec, List<String> columns) {
        if (columns.isEmpty()) {
            return IcebergUtils.asList(rec);
        }
        ArrayList<Object> res = new ArrayList<Object>(columns.size());
        for (String name : columns) {
            res.add(IcebergUtils.asGridGainValue(rec.getField(name)));
        }
        return res;
    }

    static List<Object> asList(Record rec) {
        int size = rec.size();
        ArrayList<Object> res = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            res.add(IcebergUtils.asGridGainValue(rec.get(i)));
        }
        return res;
    }

    public static GenericRecord asRecord(List<?> row, GenericRecord rec, Schema schema) {
        HashMap<String, Object> recordValues = new HashMap<String, Object>(row.size(), 1.0f);
        for (int i = 0; i < row.size(); ++i) {
            String columnName = schema.findColumnName(i + 1);
            Object value = IcebergUtils.asIcebergValue(row.get(i));
            recordValues.put(columnName, value);
        }
        return rec.copy(recordValues);
    }

    public static Schema asIcebergSchema(List<Column> ggColumns) {
        List icebergColumns = IntStream.range(1, ggColumns.size() + 1).boxed().collect(Collectors.toMap(i -> i, index -> (Column)ggColumns.get(index - 1))).entrySet().stream().map(e -> {
            int id = (Integer)e.getKey();
            boolean isOptional = ((Column)e.getValue()).nullable();
            String name = ((Column)e.getValue()).name();
            Type type = IcebergUtils.asIcebergType(((Column)e.getValue()).type());
            return Types.NestedField.of((int)id, (boolean)isOptional, (String)name, (Type)type);
        }).collect(Collectors.toList());
        return new Schema(icebergColumns);
    }

    private static Type asIcebergType(NativeType type) {
        ColumnType spec = type.spec();
        String typeString = spec.name();
        if (ColumnType.INT8 == spec || ColumnType.INT16 == spec || ColumnType.INT32 == spec) {
            return Types.IntegerType.get();
        }
        if (ColumnType.INT64 == spec) {
            return Types.LongType.get();
        }
        if (ColumnType.DECIMAL == spec) {
            DecimalNativeType decType = (DecimalNativeType)type;
            return Types.DecimalType.of((int)decType.precision(), (int)decType.scale());
        }
        if (ColumnType.DATETIME == spec) {
            return Types.TimestampType.withoutZone();
        }
        if (ColumnType.BYTE_ARRAY == spec) {
            return Types.BinaryType.get();
        }
        return Types.fromPrimitiveString((String)typeString);
    }

    public static Object asIcebergValue(@Nullable Object o) {
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        if (o instanceof Byte) {
            return ((Byte)o).intValue();
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        return o;
    }

    public static Object asGridGainValue(Object o) {
        if (o instanceof ByteBuffer) {
            return ((ByteBuffer)o).array();
        }
        if (o instanceof OffsetDateTime) {
            return LocalDateTime.ofInstant(((OffsetDateTime)o).toInstant(), ZoneOffset.UTC);
        }
        return o;
    }
}

