/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.util.UUID;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;
import org.gridgain.internal.snapshots.filesystem.EncryptedSnapshotPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotPath;

public class EncryptedSnapshotFileSystem
implements SnapshotFileSystem {
    private final SnapshotFileSystem delegate;
    private final SnapshotEncryptor encryptor;
    private final ByteBufferPoolProvider bufferPoolProvider;

    public EncryptedSnapshotFileSystem(SnapshotFileSystem delegate, SnapshotEncryptor encryptor, ByteBufferPoolProvider bufferPoolProvider) {
        this.delegate = delegate;
        this.bufferPoolProvider = bufferPoolProvider;
        this.encryptor = encryptor;
    }

    @Override
    public UUID snapshotId() {
        return this.delegate.snapshotId();
    }

    @Override
    public SnapshotMetaPath snapshotMeta() {
        return this.delegate.snapshotMeta();
    }

    @Override
    public SnapshotPath partitionFile(int tableId, int partitionId) {
        return new EncryptedSnapshotPath(this.delegate.partitionFile(tableId, partitionId), this.encryptor, this.bufferPoolProvider);
    }

    @Override
    public void delete() {
        this.delegate.delete();
    }
}

