/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesFactory;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesTypeInfos;

class RestoreSnapshotMessageDeserializer
implements MessageDeserializer<RestoreSnapshotMessage> {
    private final RestoreSnapshotMessageBuilder msg;

    RestoreSnapshotMessageDeserializer(SnapshotMessagesFactory messageFactory) {
        this.msg = messageFactory.restoreSnapshotMessage();
    }

    @Override
    public Class<RestoreSnapshotMessage> klass() {
        return RestoreSnapshotMessage.class;
    }

    @Override
    public RestoreSnapshotMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SnapshotMessagesTypeInfos.restoreSnapshotMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readString("encryptionProviderName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.encryptionProviderName((String)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("source");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.source((String)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readSet("tableNames", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableNames((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readUuid("targetSnapshotId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.targetSnapshotId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RestoreSnapshotMessage.class);
    }
}

