/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.snapshot;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.snapshot.CreateCommand;
import org.apache.ignite3.internal.rest.api.snapshot.DeleteCommand;
import org.apache.ignite3.internal.rest.api.snapshot.RestoreCommand;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotManagementApi;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotOperation;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotType;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.snapshots.SnapshotFacade;

@Controller(value="/management/v1/snapshot")
public class SnapshotManagementController
implements SnapshotManagementApi,
ResourceHolder,
SecurityContextAware {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotManagementController.class);
    private final SecurityService securityService;
    private SnapshotFacade snapshotFacade;

    public SnapshotManagementController(SnapshotFacade snapshotFacade, SecurityService securityService) {
        this.snapshotFacade = snapshotFacade;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<UUID> create(@Body CreateCommand createCommand) {
        Instant timestamp = createCommand.timestampEpochMilli() == null ? null : Instant.ofEpochMilli(createCommand.timestampEpochMilli());
        SnapshotType snapshotType = createCommand.snapshotType();
        Set<String> tableNames = createCommand.tableNames();
        Set<String> structureNames = createCommand.structureNames();
        String destination = createCommand.destination();
        String encryptionProvider = createCommand.encryptionProvider();
        LOG.info("Received snapshot creation command [snapshotType={}, tableNames={}, structureNames={}, timestamp={}, destination={}, encryptionProvider={}]", new Object[]{snapshotType, tableNames, structureNames, timestamp, destination, encryptionProvider});
        return this.secured(() -> this.snapshotFacade.createSnapshot(snapshotType, tableNames, structureNames, destination, timestamp, encryptionProvider));
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getOperations() {
        return this.secured(() -> this.snapshotFacade.getSnapshotOperationsList());
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getOperation(UUID operationId, boolean allNodes) {
        return this.secured(() -> this.snapshotFacade.getOperationById(operationId, allNodes));
    }

    @Override
    public CompletableFuture<UUID> restore(RestoreCommand restoreCommand) {
        UUID snapshotId = restoreCommand.snapshotId();
        Set<String> tableNames = restoreCommand.tableNames();
        String source = restoreCommand.source();
        String decryptionProvider = restoreCommand.decryptionProvider();
        LOG.info("Received snapshot restore command, snapshotId = {}, tableNames={}, source={}, decryptionProvider={}", snapshotId, tableNames, source, decryptionProvider);
        return this.secured(() -> this.snapshotFacade.restoreSnapshot(snapshotId, tableNames, source, decryptionProvider));
    }

    @Override
    public CompletableFuture<UUID> delete(DeleteCommand deleteCommand) {
        LOG.info("Received snapshot delete command, snapshotId = {}", deleteCommand.snapshotId());
        return this.secured(() -> this.snapshotFacade.deleteSnapshot(deleteCommand.snapshotId()));
    }

    @Override
    public void cleanResources() {
        this.snapshotFacade = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

