/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.dcr;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.dcr.AuthConfig;
import org.apache.ignite3.internal.rest.api.dcr.CreateReplicationRequest;
import org.apache.ignite3.internal.rest.api.dcr.DcrApi;
import org.apache.ignite3.internal.rest.api.dcr.FlushRequest;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationError;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationInfo;
import org.apache.ignite3.internal.rest.api.dcr.SslConfig;
import org.apache.ignite3.internal.rest.api.dcr.StartStopReplicationRequest;
import org.apache.ignite3.internal.rest.api.dcr.TableStatus;
import org.gridgain.internal.dcr.DcrManager;
import org.gridgain.internal.dcr.ReplicationOptions;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.exception.ReplicationException;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.rest.dcr.exception.InvalidCreateReplicationRequestException;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/dcr")
public class DcrController
implements DcrApi,
ResourceHolder,
SecurityContextAware {
    private DcrManager dcrManager;
    private final SecurityService securityService;

    public DcrController(DcrManager dcrManager, SecurityService securityService) {
        this.dcrManager = dcrManager;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<Collection<ReplicationInfo>> listReplications() {
        return this.dcrManager.listReplications().thenApply(replications -> replications.stream().map(DcrController::toReplicationInfo).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<ReplicationInfo> showReplication(String name) {
        return this.dcrManager.showReplication(name).thenApply(info -> {
            if (info != null) {
                return DcrController.toReplicationInfo(info);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<ReplicationInfo> createReplication(CreateReplicationRequest request) {
        try {
            return this.dcrManager.createReplication(DcrController.createReplicationOptions(request), false).thenApply(info -> {
                if (info != null) {
                    return DcrController.toReplicationInfo(info);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ReplicationOptions createReplicationOptions(CreateReplicationRequest request) {
        try {
            ReplicationOptions.ReplicationOptionsBuilder builder = ReplicationOptions.builder().name(request.name()).sourceClusterAddresses(request.sourceClusterAddresses()).authConfig(DcrController.toInternalAuthConfig(request.authConfig())).sslConfig(DcrController.toInternalSslConfig(request.sslConfig())).replicationNodes(request.replicationNodes());
            return builder.build();
        }
        catch (Exception e) {
            throw new InvalidCreateReplicationRequestException(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Boolean> startReplication(String name, StartStopReplicationRequest request) {
        if (request.allTables() != Boolean.TRUE && request.tables() == null) {
            throw new InvalidCreateReplicationRequestException("Tables must not be null");
        }
        return this.dcrManager.startReplication(name, request.schemaName(), request.tables(), Boolean.TRUE.equals(request.allTables()));
    }

    @Override
    public CompletableFuture<Boolean> stopReplication(String name, StartStopReplicationRequest request) {
        if (request.allTables() != Boolean.TRUE && request.tables() == null) {
            throw new InvalidCreateReplicationRequestException("Tables must not be null");
        }
        return this.dcrManager.stopReplication(name, request.schemaName(), request.tables(), Boolean.TRUE.equals(request.allTables()));
    }

    @Override
    public CompletableFuture<Boolean> deleteReplication(String name) {
        return this.dcrManager.removeReplication(name);
    }

    @Override
    public CompletableFuture<Boolean> flush(String name, FlushRequest flushRequest) {
        return this.dcrManager.flushReplication(name, flushRequest.flushPoint());
    }

    private static ReplicationInfo toReplicationInfo(org.gridgain.internal.dcr.ReplicationInfo info) {
        ReplicationException exception = info.exception();
        List<ReplicationError> errors = exception == null ? Collections.emptyList() : Collections.singletonList(new ReplicationError(exception.workerNode(), exception.failedEntry(), exception.toString()));
        return new ReplicationInfo(info.name(), info.sourceClusterAddresses(), DcrController.toAuthConfig(info.authConfig()), DcrController.toSslConfig(info.sslConfig()), info.sourceClusterName(), info.targetClusterName(), info.workerNodeName(), info.schemaName(), DcrController.toTableStatuses(info.tableStatuses()), org.apache.ignite3.internal.rest.api.dcr.ReplicationStatus.valueOf(info.status().name()), info.fstProgress(), errors);
    }

    @Override
    public void cleanResources() {
        this.dcrManager = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    @Nullable
    private static AuthConfig toAuthConfig(@Nullable org.gridgain.internal.dcr.AuthConfig authConfig) {
        if (authConfig == null) {
            return null;
        }
        return new AuthConfig(authConfig.username(), DcrController.maskPassword(authConfig.password()));
    }

    @Nullable
    private static SslConfig toSslConfig(@Nullable org.gridgain.internal.dcr.SslConfig sslConfig) {
        if (sslConfig == null) {
            return null;
        }
        return new SslConfig(sslConfig.ciphers(), sslConfig.keyStorePath(), DcrController.maskPassword(sslConfig.keyStorePassword()), sslConfig.trustStorePath(), DcrController.maskPassword(sslConfig.trustStorePassword()));
    }

    @Nullable
    private static org.gridgain.internal.dcr.AuthConfig toInternalAuthConfig(@Nullable AuthConfig authConfig) {
        if (authConfig == null) {
            return null;
        }
        return org.gridgain.internal.dcr.AuthConfig.builder().username(authConfig.username()).password(authConfig.password()).build();
    }

    @Nullable
    private static org.gridgain.internal.dcr.SslConfig toInternalSslConfig(@Nullable SslConfig sslConfig) {
        if (sslConfig == null) {
            return null;
        }
        return org.gridgain.internal.dcr.SslConfig.builder().ciphers(sslConfig.ciphers()).keyStorePath(sslConfig.keyStorePath()).keyStorePassword(sslConfig.keyStorePassword()).trustStorePath(sslConfig.trustStorePath()).trustStorePassword(sslConfig.trustStorePassword()).build();
    }

    private static List<TableStatus> toTableStatuses(Map<String, ReplicationStatus> tableStatuses) {
        return tableStatuses.entrySet().stream().map(entry -> new TableStatus((String)entry.getKey(), org.apache.ignite3.internal.rest.api.dcr.ReplicationStatus.valueOf(((ReplicationStatus)((Object)((Object)entry.getValue()))).name()))).collect(Collectors.toList());
    }

    @Nullable
    private static String maskPassword(@Nullable String password) {
        if (password == null) {
            return null;
        }
        return "********";
    }
}

