/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite3.internal.replicator.ReplicaManager;
import org.apache.ignite3.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.pitr.PitrManager;
import org.gridgain.internal.pitr.configuration.NodePitrConfiguration;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;

public class PitrManagerContext
implements ManuallyCloseable {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final PointInTimeRecoveryMessagesFactory messagesFactory = new PointInTimeRecoveryMessagesFactory();
    private final ClusterService clusterService;
    private final MetaStorageManagerImpl metaStorageManager;
    private final CatalogManager catalogManager;
    private final TableManager tableManager;
    private final TxManager txManager;
    private final DistributionZoneManager distributionZoneManager;
    private final LogicalTopologyService logicalTopologyService;
    private final HybridClock clock;
    private final ReplicationConfiguration replicationConfiguration;
    private final ReplicaManager replicaManager;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final NodeProperties nodeProperties;
    private final ThreadPoolExecutor threadPool;

    PitrManagerContext(NodePitrConfiguration pitrConfiguration, ClusterService clusterService, MetaStorageManagerImpl metaStorageManager, CatalogManager catalogManager, TableManager tableManager, TxManager txManager, DistributionZoneManager distributionZoneManager, LogicalTopologyService logicalTopologyService, HybridClock clock, ReplicationConfiguration replicationConfiguration, ReplicaManager replicaManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, NodeProperties nodeProperties) {
        this.clusterService = clusterService;
        this.metaStorageManager = metaStorageManager;
        this.catalogManager = catalogManager;
        this.tableManager = tableManager;
        this.txManager = txManager;
        this.distributionZoneManager = distributionZoneManager;
        this.logicalTopologyService = logicalTopologyService;
        this.clock = clock;
        this.replicationConfiguration = replicationConfiguration;
        this.replicaManager = replicaManager;
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.nodeProperties = nodeProperties;
        int threadPoolSize = (Integer)pitrConfiguration.threadPoolSize().value();
        this.threadPool = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(clusterService.nodeName(), "gg-pitr", Loggers.forClass(PitrManager.class), ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE));
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    public MessagingService messagingService() {
        return this.clusterService.messagingService();
    }

    public PointInTimeRecoveryMessagesFactory messagesFactory() {
        return this.messagesFactory;
    }

    public TopologyService topology() {
        return this.clusterService.topologyService();
    }

    public MetaStorageManagerImpl metaStorageManager() {
        return this.metaStorageManager;
    }

    public ThreadPoolExecutor threadPool() {
        return this.threadPool;
    }

    public TableManager tableManager() {
        return this.tableManager;
    }

    public TxManager txManager() {
        return this.txManager;
    }

    public DistributionZoneManager distributionZoneManager() {
        return this.distributionZoneManager;
    }

    public LogicalTopologyService logicalTopologyService() {
        return this.logicalTopologyService;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public HybridClock clock() {
        return this.clock;
    }

    public ReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public PartitionReplicaLifecycleManager partitionReplicaLifecycleManager() {
        return this.partitionReplicaLifecycleManager;
    }

    public NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public IgniteSpinBusyLock busyLock() {
        return this.busyLock;
    }

    @Override
    public void close() {
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination(this.threadPool, 30L, TimeUnit.SECONDS);
    }

    public String nodeName() {
        return this.clusterService.nodeName();
    }
}

