/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.time.Duration;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.ignite3.internal.metrics.MetricSet;
import org.apache.ignite3.internal.metrics.MetricSetBuilder;
import org.apache.ignite3.internal.metrics.MetricSource;
import org.gridgain.internal.license.GridLicenseManager;
import org.gridgain.internal.license.HoconLicenseField;
import org.jetbrains.annotations.Nullable;

public class LicenseMetricSource
implements MetricSource {
    public static final String SOURCE_NAME = "license";
    private final GridLicenseManager licenseManager;
    private boolean enabled;

    public LicenseMetricSource(GridLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        MetricSetBuilder builder = new MetricSetBuilder(SOURCE_NAME);
        builder.longGauge("DaysToLicenseExpiration", "The number of days left to license expiration.", () -> {
            LocalDate expirationDate = this.licenseManager.currentLicense().field(HoconLicenseField.EXPIRE_DATE);
            Duration tillExpiration = Duration.between(LocalDate.now().atStartOfDay(), expirationDate.atStartOfDay());
            return tillExpiration.toDays();
        });
        builder.intGauge("MaxNumberOfCores", "The maximum number of cores allowed as a sum of cores of all cluster nodes (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_CORES), 0));
        builder.intGauge("MaxNumberOfNodes", "The maximum number of nodes allowed as a number of all cluster nodes (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_NODES), 0));
        builder.intGauge("MaxNumberOfHosts", "The maximum number of hosts allowed as a number of all hosts where the cluster nodes are located (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_HOSTS), 0));
        builder.longGauge("MaxHeapSize", "The maximum heap size allowed as a sum of configured maximum heap sizes on each cluster node (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_HEAP_SIZE), 0L));
        builder.longGauge("MaxOffheapSize", "The maximum off-heap size allowed as a sum of all storage profiles sizes of each cluster node (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_OFFHEAP_SIZE), 0L));
        builder.longGauge("MaxRamSize", "The maximum RAM size allowed as a sum of available RAM from each host (0 is unlimited).", () -> Objects.requireNonNullElse(this.licenseManager.currentLicense().field(HoconLicenseField.MAX_RAM_SIZE), 0L));
        this.enabled = true;
        return builder.build();
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }
}

