/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.user.GetUserCall;
import org.gridgain.internal.cli.call.rbac.user.ShowUserCallInput;
import org.gridgain.internal.cli.decorators.UserDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show user information"})
public class UserShowReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Username"})
    private String username;
    @CommandLine.Option(names={"--with-roles"}, description={"Show user with assigned roles"})
    private boolean roles;
    @Inject
    private GetUserCall getUserCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.getUserCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show user")).print(new UserDecorator()));
    }

    private ShowUserCallInput input(String clusterUrl) {
        return ShowUserCallInput.builder().clusterUrl(clusterUrl).username(this.username).showRoles(this.roles).build();
    }
}

