/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.user.ListUsersCall;
import org.gridgain.internal.cli.call.rbac.user.ListUsersCallInput;
import org.gridgain.internal.cli.decorators.UserListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List users"})
public class UserListCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--role", "-r"}, description={"Filter by role name"})
    private String role;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListUsersCall listUsersCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.listUsersCall).inputProvider(() -> ListUsersCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).filterByRoleName(this.role).build()).decorator(new UserListDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot list users")));
    }
}

