/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.policy;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.table.policy.RlsCheckerChain;
import org.apache.ignite3.internal.table.policy.RlsContext;
import org.apache.ignite3.internal.table.policy.RlsPolicy;
import org.apache.ignite3.internal.table.policy.VersionResolver;
import org.jetbrains.annotations.Nullable;

class PolicyBasedChecker
extends RlsCheckerChain {
    private final Predicate<String> roleNamePredicateForAlwaysTruePolicy;
    private final SchemaRegistry schemaRegistry;
    private final List<RlsPolicy> policies;
    private final VersionResolver versionResolver;

    PolicyBasedChecker(VersionResolver versionResolver, Predicate<String> roleNamePredicateForAlwaysTruePolicy, List<RlsPolicy> policies, SchemaRegistry schemaRegistry, long since, @Nullable RlsCheckerChain prev) {
        super(since, prev);
        this.versionResolver = versionResolver;
        this.roleNamePredicateForAlwaysTruePolicy = roleNamePredicateForAlwaysTruePolicy;
        this.policies = policies;
        this.schemaRegistry = schemaRegistry;
    }

    @Override
    public boolean isRowVisible(RlsContext rlsContext, HybridTimestamp timestamp, BinaryRow row) {
        return this.checkPolicies(rlsContext, timestamp, row);
    }

    @Override
    public boolean isRowInsertable(RlsContext rlsContext, HybridTimestamp timestamp, BinaryRow row) {
        return this.checkPolicies(rlsContext, timestamp, row);
    }

    @Override
    public boolean isRowUpdatable(RlsContext rlsContext, HybridTimestamp timestamp, BinaryRow oldRow, BinaryRow newRow) {
        return this.checkPolicies(rlsContext, timestamp, oldRow) && this.checkPolicies(rlsContext, timestamp, newRow);
    }

    @Override
    public boolean isRowDeletable(RlsContext rlsContext, HybridTimestamp timestamp, BinaryRow row) {
        return this.checkPolicies(rlsContext, timestamp, row);
    }

    private boolean checkPolicies(RlsContext rlsContext, HybridTimestamp timestamp, BinaryRow row) {
        if (RlsContext.isSystemUser(rlsContext)) {
            return true;
        }
        boolean result = false;
        if (!this.policies.isEmpty()) {
            int version = this.versionResolver.version(timestamp.longValue());
            SchemaDescriptor descriptor = this.schemaRegistry.schema(version);
            Row resolvedRow = this.schemaRegistry.resolve(row, descriptor);
            block5: for (RlsPolicy policy : this.policies) {
                RlsPolicy.Result checkResult = policy.check(rlsContext, resolvedRow);
                switch (checkResult) {
                    case ACCESS_FORBIDDEN: {
                        return false;
                    }
                    case ACCESS_ALLOWED: {
                        result = true;
                        continue block5;
                    }
                    case NOT_APPLICABLE: {
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown policy check result: " + checkResult));
            }
        }
        if (!result && this.alwaysTruePolicyApplies(rlsContext.roles())) {
            result = true;
        }
        return result;
    }

    private boolean alwaysTruePolicyApplies(Set<String> roles) {
        for (String role : roles) {
            if (!this.roleNamePredicateForAlwaysTruePolicy.test(role)) continue;
            return true;
        }
        return false;
    }
}

